package com.fshows.msfpay.request;

import com.fshows.msfpay.request.item.MsfpayWhitelistItemRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * CAS050-添加会员分账白名单请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayMemberSplitWhitelistRequest extends MsfpayBizRequest {

    /**
     * 商户编号
     * 必填: 是
     * 长度: 12
     * 说明: 支持平台商户与二级商户
     */
    @NotBlank(message = "商户编号不能为空")
    private String merid;

    /**
     * 前端通知地址
     * 必填: 否
     * 长度: 128
     */
    private String weburl;

    /**
     * 白名单列表
     * 必填: 是
     * 长度: 1024
     * 说明: JSON对象数组，格式：[{"memUserId":"US1000000420"}]
     * 对应对象: MsfpayWhitelistItemRequest
     */
    @NotEmpty(message = "白名单列表不能为空")
    private List<MsfpayWhitelistItemRequest> whilelist;
}
