package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * CMS050-会员信息查询请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayMemberInfoQueryRequest extends MsfpayBizRequest {

    /**
     * 会员编号
     * 必填: 否
     * 长度: 12
     * 说明: 当输入了会员编号时优先以会员编号进行查询，会员编号为空时证件号码、签约手机号、银行卡号至少填一个
     */
    private String memUserId;

    /**
     * 证件号码
     * 必填: 否
     * 长度: 22
     */
    private String custcertno;

    /**
     * 客户名称
     * 必填: 否
     * 长度: 64
     */
    private String custname;

    /**
     * 签约手机号
     * 必填: 否
     * 长度: 32
     */
    private String signphone;

    /**
     * 银行卡号
     * 必填: 否
     * 长度: 32
     * 说明: 非空时会返回对应绑定状态，为空时且会员状态正常，返回该会员的全部绑定成功状态的绑定银行账户信息
     */
    private String bankcardno;
}
