package com.fshows.msfpay.request;

import com.fshows.msfpay.request.item.MsfpayProductItemListRequest;
import com.fshows.msfpay.request.item.MsfpayProfitItemListRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * CAS038-分期支付请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayInstallmentPayRequest extends MsfpayBizRequest {

    /**
     * 商户id
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "商户id不能为空")
    private String merid;

    /**
     * 账号
     * 必填: 否
     * 长度: 32
     * 说明: 银行卡号
     */
    private String accountno;

    /**
     * 短卡号
     * 必填: 否
     * 长度: 10
     * 说明: 短卡号，由卡号前六位后四位组成，可由此确定客户上次上送的卡号
     */
    private String storablecardno;

    /**
     * 银行编码
     * 必填: 否
     * 长度: 8
     * 说明: 0305000a为无卡流程。更多支持银行后续再更新添加
     */
    private String bankcode;

    /**
     * 账户名称
     * 必填: 否
     * 长度: 60
     * 说明: 银行卡对应的名称
     */
    private String accountname;

    /**
     * 交易金额
     * 必填: 是
     * 长度: 16,2
     * 说明: 订单金额,保留小数2位。整数位最大为14位。
     */
    @NotNull(message = "交易金额不能为空")
    private BigDecimal tranamt;

    /**
     * 证件类型
     * 必填: 否
     * 长度: 2
     * 说明: 01：身份证；目前仅支持身份证，默认为身份证类型
     */
    private String certtype;

    /**
     * 证件号
     * 必填: 否
     * 长度: 22
     * 说明: 身份证号码
     */
    private String certno;

    /**
     * 手机号码
     * 必填: 否
     * 长度: 13
     * 说明: 银行预留手机号
     */
    private String mobileno;

    /**
     * 客户号
     * 必填: 否
     * 长度: 30
     * 说明: 商户自行定义的客户号，由此返显客户的支付卡号等信息，优化客户体验（一个身份证只能绑定一个客户号）
     */
    private String custid;

    /**
     * 服务器回调地址
     * 必填: 否
     * 长度: 128
     * 说明: 订单成功之后作为服务器回调的地址
     */
    private String serverurl;

    /**
     * 支付页面回调地址
     * 必填: 是
     * 长度: 128
     * 说明: 交易结束后（成功或失败）跳转到该页面
     */
    @NotBlank(message = "支付页面回调地址不能为空")
    private String weburl;

    /**
     * 平台手续费
     * 必填: 是
     * 长度: 16,2
     * 说明: 平台商户开通之后三方平台会告知订单收费规则按照三方指定的收费规则计算上送。当平台商户配置关闭分账功能后非必输,此时输入无效
     */
    @NotNull(message = "平台手续费不能为空")
    private BigDecimal patfee;

    /**
     * 分账类型
     * 必填: 是
     * 长度: 2
     * 说明: 00:百分比 01:按金额分账，当平台商户配置关闭分账功能后非必输,此时输入无效
     */
    @NotBlank(message = "分账类型不能为空")
    private String profittype;

    /**
     * 分账信息
     * 必填: 是
     * 长度: 255
     * 说明: {"profitlist":[{"merid":"CF3000038556","proportion":"0.8","prno":"1000000001"},{"merid":"CF3000038508","proportion":"0.2","prno":"1000000001"}]}
     * 对应对象: MsfpayProfitItemListRequest
     * prno为项目编号,非必输。当平台商户配置关闭分账功能后非必输,此时输入无效
     */
    @NotNull(message = "分账信息不能为空")
    private MsfpayProfitItemListRequest profitlist;

    /**
     * 商品信息
     * 必填: 是
     * 长度: 255
     * 说明: {"productlist":[{"productname":"牙刷","productnum":"2","productamt":"0.5"},{"productname":"电脑","productnum":"2","productamt":"4000"}]}
     * 对应对象: MsfpayProductItemListRequest
     * productname为商品名称，productnum为商品数量，productamt为商品金额
     */
    @NotNull(message = "商品信息不能为空")
    private MsfpayProductItemListRequest productlist;

    /**
     * 扩展字段
     * 必填: 否
     * 长度: 600
     */
    private String extendfield;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     */
    private String prno;

    /**
     * 分期期数
     * 必填: 否
     * 长度: 2
     * 说明: 0/3/6/12
     */
    private String instalperiod;
}
