package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * CAS020-手续费转账请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayFeeTransferRequest extends MsfpayBizRequest {

    /**
     * 金额
     * 必填: 是
     * 长度: 16,2
     * 说明: 以元单位，小数部分四舍五入保留2位小数
     */
    @NotNull(message = "金额不能为空")
    private BigDecimal tranamt;

    /**
     * 备注
     * 必填: 是
     * 长度: 100
     */
    @NotBlank(message = "备注不能为空")
    private String remark;

    /**
     * 服务器回调地址
     * 必填: 是
     * 长度: 128
     * 说明: 订单成功之后作为服务器回调的地址
     */
    @NotBlank(message = "服务器回调地址不能为空")
    private String serverurl;
}
