package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CMS034-手续费补贴查询请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayFeeSubsidyQueryRequest extends MsfpayBizRequest {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "中投商户号不能为空")
    private String merid;

    /**
     * 活动编码
     * 必填: 否
     * 长度: 32
     */
    private String activityCode;

    /**
     * 费率编号
     * 必填: 否
     * 长度: 32
     */
    private String id;

    /**
     * 支付类型
     * 必填: 否
     * 长度: 12
     * 说明: WEIXIN:微信 ALI:支付宝 UP:银联二维码 HUABEI:花呗分期 QUICKPAY:快捷支付
     */
    private String payType;

    /**
     * 费率规则状态
     * 必填: 否
     * 长度: 20
     * 说明: USABLE:可用 DISABLE:不可用 EXPIRED:已过期 WAIT_AUDIT:待审核 AUDIT_REJECT:审核拒绝
     */
    private String state;
}
