package com.fshows.msfpay.request;

import com.fshows.msfpay.request.item.MsfpayModContentRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * CMS059-创建手续费补贴红包请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayFeeSubsidyCouponCreateRequest extends MsfpayBizRequest {

    /**
     * 商户号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "商户号不能为空")
    private String merid;

    /**
     * 操作类型
     * 必填: 是
     * 长度: 12
     * 说明: 00-创建;01-修改;02-升级
     */
    @NotBlank(message = "操作类型不能为空")
    private String opType;

    /**
     * 活动编码
     * 必填: 否
     * 说明: 1、opType=00时参数样例：["MKT0001"，"MKT0002""MKT0003"]
     *       2、opType=01或opType=02时，仅支持传入一个活动编码
     *       传入中投科信的活动编号，若不上送该参数，将匹配允许该商户参加的补贴活动，进行补贴申请
     */
    private List<String> activityCode;

    /**
     * 补贴类型
     * 必填: 否
     * 长度: 2
     * 说明: 00-中小微型商户补贴;01-对公客户补贴;02-连锁行业客户补贴
     */
    private String subType;

    /**
     * 新活动编码
     * 必填: 否
     * 长度: 32
     * 说明: 操作类型为opType=02-升级时，必填，填写变更后的活动编码
     */
    private String newActivityCode;

    /**
     * 修改活动内容
     * 必填: 否
     * 说明: JSON格式的字符串数组：[{"couponCode":"","couponAmt":"","startTime":"","endTime":"","state":""}]
     *       操作类型为opType=01-修改时，必填，变更已生成的手续费红包信息，填写手续费红包要修改的内容,其他操作类型时填写无效
     */
    private List<MsfpayModContentRequest> modContent;

    /**
     * 通知地址
     * 必填: 否
     * 长度: 12
     * 说明: 传入商户侧用于接收审核结果的通知的地址，不上送该参数时，审核完成将不会触发异步通知报文
     */
    private String notifyUrl;
}
