package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CMS033-手续费补贴配置请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayFeeSubsidyConfigRequest extends MsfpayBizRequest {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "中投商户号不能为空")
    private String merid;

    /**
     * 活动编码
     * 必填: 是
     * 长度: 32
     */
    @NotBlank(message = "活动编码不能为空")
    private String activityCode;

    /**
     * 费率相关数据
     * 必填: 否
     * 长度: 2000
     * 说明: 补贴费率，当活动限制新商户配置且二级商户为新商户时不需要输入，否则必输
     */
    private String rules;
}
