package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CMS021-额度业务申请请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayCreditBusinessApplyRequest extends MsfpayBizRequest {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "中投商户号不能为空")
    private String merid;

    /**
     * 申请开通业务
     * 必填: 是
     * 长度: 8
     * 说明: 额度提现：CAS025，额度后分账：CAS051
     */
    @NotBlank(message = "申请开通业务不能为空")
    private String applybus;

    /**
     * 服务器回调地址
     * 必填: 是
     * 长度: 128
     * 说明: 后台操作变更状态时通知商户
     */
    @NotBlank(message = "服务器回调地址不能为空")
    private String serverurl;
}
