package com.fshows.msfpay.request;

import com.fshows.msfpay.request.item.MsfpayFeeSubsidyRuleItemRequest;
import com.fshows.msfpay.request.item.MsfpayProductItemListRequest;
import com.fshows.msfpay.request.item.MsfpayProfitItemListRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * CAS030-协议支付请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayAgreementPayRequest extends MsfpayBizRequest {

    /**
     * 商户id
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "商户id不能为空")
    private String merid;

    /**
     * 外部用户号
     * 必填: 否
     * 长度: 32
     */
    private String outuserid;

    /**
     * 账号
     * 必填: 是
     * 长度: 32
     * 说明: 银行卡号或者存折号码
     */
    @NotBlank(message = "账号不能为空")
    private String accountno;

    /**
     * 账户名称
     * 必填: 是
     * 长度: 60
     * 说明: 银行卡或者存折上对应的名称
     */
    @NotBlank(message = "账户名称不能为空")
    private String accountname;

    /**
     * 交易金额
     * 必填: 是
     * 长度: 16,2
     * 说明: 银行卡被扣费的金额,保留小数2位。整数位最大为14位。
     */
    @NotNull(message = "交易金额不能为空")
    private BigDecimal tranamt;

    /**
     * 开户证件类型
     * 必填: 是
     * 长度: 2
     * 说明: 01：身份证；目前仅支持身份证
     */
    @NotBlank(message = "开户证件类型不能为空")
    private String certtype;

    /**
     * 证件号
     * 必填: 是
     * 长度: 22
     * 说明: 身份证号码
     */
    @NotBlank(message = "证件号不能为空")
    private String certno;

    /**
     * 手机号码
     * 必填: 是
     * 长度: 13
     * 说明: 银行预留手机号
     */
    @NotBlank(message = "手机号码不能为空")
    private String mobileno;

    /**
     * 卡有效期
     * 必填: 否
     * 长度: 4
     * 说明: 卡号为借记卡时，无需输入
     */
    private String expireddate;

    /**
     * cvv2
     * 必填: 否
     * 长度: 3
     * 说明: 卡号为借记卡时，无需输入
     */
    private String cvv2;

    /**
     * 服务器回调地址
     * 必填: 否
     * 长度: 128
     * 说明: 订单成功之后作为服务器回调的地址
     */
    private String serverurl;

    /**
     * 订单类型
     * 必填: 是
     * 长度: 2
     * 说明: 订单类型： 0:普通交易  1:担保交易
     */
    @NotBlank(message = "订单类型不能为空")
    private String ordertype;

    /**
     * 平台手续费
     * 必填: 是
     * 长度: 16,2
     * 说明: 平台商户开通之后三方平台会告知订单收费规则按照三方指定的收费规则计算上送。当平台商户配置关闭分账功能后非必输,此时输入无效
     */
    @NotNull(message = "平台手续费不能为空")
    private BigDecimal patfee;

    /**
     * 分账类型
     * 必填: 是
     * 长度: 2
     * 说明: 见附录，当平台商户配置关闭分账功能后非必输,此时输入无效
     */
    @NotBlank(message = "分账类型不能为空")
    private String profittype;

    /**
     * 分账信息
     * 必填: 是
     * 长度: 255
     * 说明: {"profitlist":[{"merid":"CF3000038556","proportion":"0.8","prno":"1000000001"},{"merid":"CF3000038508","proportion":"0.2","prno":"1000000001"}]}
     * 对应对象: MsfpayProfitItemListRequest
     * prno为项目编号,非必输。当平台商户配置关闭分账功能后非必输,此时输入无效
     */
    @NotNull(message = "分账信息不能为空")
    private MsfpayProfitItemListRequest profitlist;

    /**
     * 商品信息
     * 必填: 是
     * 长度: 255
     * 说明: {"productlist":[{"productname":"牙刷","productnum":"2","productamt":"0.5"},{"productname":"电脑","productnum":"2","productamt":"4000"}]}
     * 对应对象: MsfpayProductItemListRequest
     * productname为商品名称，productnum为商品数量，productamt为商品金额
     */
    @NotNull(message = "商品信息不能为空")
    private MsfpayProductItemListRequest productlist;

    /**
     * 扩展字段
     * 必填: 否
     * 长度: 600
     */
    private String extendfield;

    /**
     * 优惠标识
     * 必填: 否
     * 长度: 32
     * 说明: 通过CAS044接口获取
     */
    private String coupontoken;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     */
    private String prno;

    /**
     * 手续费补贴费率明细
     * 必填: 否
     * 说明: [{"activityCode":"MKT1000000000","payType":"QUICKPAY","subsidyRatio":0.1},{"activityCode":"MKT1000000001","payType":"QUICKPAY","subsidyRatio":0.2}]
     * 对应对象: MsfpayFeeSubsidyRuleItemRequest
     */
    private List<MsfpayFeeSubsidyRuleItemRequest> feeSubsidyRuleList;
}
