package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CAS011-账户余额查询请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayAccountBalanceQueryRequest extends MsfpayBizRequest {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "中投商户号不能为空")
    private String merid;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     */
    private String prno;
}
