/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.msfpay.utils;

import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import msfpay.cfca.sadk.algorithm.common.CBCParam;
import msfpay.cfca.sadk.algorithm.common.Mechanism;
import msfpay.cfca.sadk.algorithm.common.PKCS7EnvelopedData;
import msfpay.cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import msfpay.cfca.sadk.algorithm.util.RSAAndItsCloseSymAlgUtil;
import msfpay.cfca.sadk.algorithm.util.SM2AndItsCloseSymAlgUtil;
import msfpay.cfca.sadk.asn1.parser.ASN1Parser;
import msfpay.cfca.sadk.lib.crypto.Session;
import msfpay.cfca.sadk.lib.crypto.jni.JNISoftLib;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import msfpay.cfca.sadk.org.bouncycastle.asn1.BEROctetString;
import msfpay.cfca.sadk.org.bouncycastle.asn1.DERNull;
import msfpay.cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import msfpay.cfca.sadk.org.bouncycastle.asn1.DERSet;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.EnvelopedData;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.RecipientIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.RecipientInfo;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.cms.CMSEnvelopedData;
import msfpay.cfca.sadk.util.Base64;
import msfpay.cfca.sadk.util.CertUtil;
import msfpay.cfca.sadk.x509.certificate.X509Cert;

public class SM2EnvelopeUtil {
    private static byte[] IV_16 = new byte[]{50, 51, 52, 53, 54, 55, 56, 57, 56, 55, 54, 53, 52, 51, 50, 49};

    public static final byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session) throws Exception {
        byte[] none64 = SM2EnvelopeUtil.envelopMessage_None64(sourceData, symmetricAlgorithm, receiverCerts, session);
        return Base64.encode((byte[])none64);
    }

    private static byte[] envelopMessage_None64(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session) throws Exception {
        Mechanism contentEncryptionAlg;
        byte[] key = SM2AndItsCloseSymAlgUtil.generateSecretKey();
        IV_16 = SM2AndItsCloseSymAlgUtil.generateIV();
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        for (X509Cert receiverCert : receiverCerts) {
            recipientInfos.add((ASN1Encodable)SM2EnvelopeUtil.toRecipientInfoOfIssuerAndSerialNumber(receiverCert, key, session));
        }
        if (symmetricAlgorithm.contains("CBC")) {
            CBCParam cbc = new CBCParam(IV_16);
            contentEncryptionAlg = new Mechanism(symmetricAlgorithm, (Object)cbc);
        } else {
            contentEncryptionAlg = new Mechanism(symmetricAlgorithm);
        }
        boolean useJNI = session instanceof JNISoftLib;
        byte[] encryptedData = SM2AndItsCloseSymAlgUtil.crypto((boolean)useJNI, (boolean)true, (byte[])key, (byte[])sourceData, (Mechanism)contentEncryptionAlg);
        BEROctetString encryptedOctet = new BEROctetString(encryptedData);
        ASN1ObjectIdentifier tOID = (ASN1ObjectIdentifier)PKCS7EnvelopedData.MECH_OID.get(symmetricAlgorithm);
        AlgorithmIdentifier algId = SM2EnvelopeUtil.getAlgorithmIdentifier(contentEncryptionAlg, tOID);
        EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo(PKCSObjectIdentifiers.sm2Data, algId, (ASN1OctetString)encryptedOctet);
        EnvelopedData envData = new EnvelopedData(null, (ASN1Set)new DERSet(recipientInfos), encryptedContentInfo, ASN1Set.getInstance(null));
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.sm2EnvelopedData, (ASN1Encodable)envData);
        return ASN1Parser.parseDERObj2Bytes((ASN1Encodable)new CMSEnvelopedData(contentInfo).toASN1Structure());
    }

    public static byte[] openEvelopedMessage(byte[] base64EnvelopeMessage, PrivateKey privateKey, X509Cert recipientCert, Session session) throws Exception {
        if (session == null) {
            throw new IllegalArgumentException("session\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            boolean isSM2Type = CertUtil.isSM2Cert((X509Cert)recipientCert);
            byte[] bEnvelop = Base64.decode((byte[])base64EnvelopeMessage);
            CMSEnvelopedData cmsEnData = new CMSEnvelopedData(bEnvelop);
            ContentInfo info = cmsEnData.toASN1Structure();
            EnvelopedData enData = EnvelopedData.getInstance((Object)info.getContent());
            ASN1Set receivers = enData.getRecipientInfos();
            X500Name recipientIssuer = recipientCert.getIssuerX500Name();
            BigInteger recipientSN = recipientCert.getSerialNumber();
            byte[] subjectPubKeyID = recipientCert.getSubjectKeyIdentifier().getKeyIdentifier();
            if (receivers == null) {
                throw new Exception("\u63a5\u6536\u8005\u4e3a\u7a7a");
            }
            ASN1OctetString encryptKey = null;
            AlgorithmIdentifier algId = null;
            for (int i = 0; i < receivers.size(); ++i) {
                KeyTransRecipientInfo inf;
                RecipientInfo recip = RecipientInfo.getInstance((Object)receivers.getObjectAt(i));
                if (!(recip.getInfo() instanceof KeyTransRecipientInfo) || !SM2EnvelopeUtil.hasRecipent(inf = KeyTransRecipientInfo.getInstance((Object)recip.getInfo()), subjectPubKeyID, recipientIssuer, recipientSN)) continue;
                encryptKey = inf.getEncryptedKey();
                algId = inf.getKeyEncryptionAlgorithm();
                break;
            }
            if (encryptKey == null || algId == null) {
                throw new Exception("\u627e\u4e0d\u5230\u63a5\u6536\u8005");
            }
            Mechanism contentEncryptionAlg = isSM2Type ? new Mechanism("SM2") : new Mechanism("RSA/ECB/PKCS1PADDING");
            byte[] symmetricKey = session.decrypt(contentEncryptionAlg, (Key)privateKey, encryptKey.getOctets());
            EncryptedContentInfo data = enData.getEncryptedContentInfo();
            ASN1OctetString os = data.getEncryptedContent();
            AlgorithmIdentifier symmetricAlgId = data.getContentEncryptionAlgorithm();
            String encryptionAlgStr = (String)PKCS7EnvelopedData.OID_MECH.get(symmetricAlgId.getAlgorithm());
            Mechanism mechanism = null;
            if (encryptionAlgStr.contains("CBC")) {
                DEROctetString doct = (DEROctetString)symmetricAlgId.getParameters();
                CBCParam sourceData = new CBCParam(doct.getOctets());
                if (encryptionAlgStr.equals("DESede/CBC/PKCS7Padding")) {
                    mechanism = new Mechanism("DESede/CBC/PKCS7Padding", (Object)sourceData);
                } else if (encryptionAlgStr.equals("SM4/CBC/PKCS7Padding")) {
                    mechanism = new Mechanism("SM4/CBC/PKCS7Padding", (Object)sourceData);
                }
            } else if (encryptionAlgStr.contains("ECB")) {
                if (encryptionAlgStr.equals("DESede/ECB/PKCS7Padding")) {
                    mechanism = new Mechanism("DESede/ECB/PKCS7Padding");
                } else if (encryptionAlgStr.equals("SM4/ECB/PKCS7Padding")) {
                    mechanism = new Mechanism("SM4/ECB/PKCS7Padding");
                }
            } else if (encryptionAlgStr.contains("RC4")) {
                mechanism = new Mechanism("RC4");
            }
            if (mechanism == null) {
                throw new Exception("\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u7b97\u6cd5: " + encryptionAlgStr);
            }
            boolean useJNI = session instanceof JNISoftLib;
            return isSM2Type ? SM2AndItsCloseSymAlgUtil.crypto((boolean)useJNI, (boolean)false, (byte[])symmetricKey, (byte[])os.getOctets(), (Mechanism)mechanism) : RSAAndItsCloseSymAlgUtil.crypto((boolean)useJNI, (boolean)false, (byte[])symmetricKey, (byte[])os.getOctets(), (Mechanism)mechanism);
        }
        catch (Exception e) {
            throw new Exception("\u89e3\u6790\u6d88\u606f\u6570\u5b57\u4fe1\u5c01\u5931\u8d25", e);
        }
    }

    private static AlgorithmIdentifier getAlgorithmIdentifier(Mechanism contentEncryptionAlg, ASN1ObjectIdentifier tOID) throws Exception {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(tOID);
        if (contentEncryptionAlg.getMechanismType().contains("CBC")) {
            Object param = contentEncryptionAlg.getParam();
            if (param == null) {
                throw new Exception("P7\u4fe1\u5c01CBC\u53c2\u6570\u4e3a\u7a7a");
            }
            CBCParam cbcParam = (CBCParam)contentEncryptionAlg.getParam();
            DEROctetString doct = new DEROctetString(cbcParam.getIv());
            return new AlgorithmIdentifier(tOID, (ASN1Encodable)doct);
        }
        return algorithmIdentifier;
    }

    private static RecipientInfo toRecipientInfoOfIssuerAndSerialNumber(X509Cert cert, byte[] symmetricKey, Session session) throws Exception {
        byte[] encryptedKey = session instanceof JNISoftLib ? SM2AndItsCloseSymAlgUtil.sm2EncryptByJNI((boolean)true, (Key)cert.getPublicKey(), (byte[])symmetricKey) : SM2AndItsCloseSymAlgUtil.sm2Encrypt((boolean)true, (Key)cert.getPublicKey(), (byte[])symmetricKey);
        DEROctetString encKey = new DEROctetString(encryptedKey);
        X500Name recipientIssuer = cert.getIssuerX500Name();
        BigInteger recipientSN = cert.getSerialNumber();
        IssuerAndSerialNumber issu = new IssuerAndSerialNumber(recipientIssuer, recipientSN);
        AlgorithmIdentifier keyEncAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.SM2_pubKey_encrypt, (ASN1Encodable)DERNull.INSTANCE);
        KeyTransRecipientInfo ktr = new KeyTransRecipientInfo(RecipientIdentifier.getInstance((Object)issu), keyEncAlg, (ASN1OctetString)encKey);
        return new RecipientInfo(ktr);
    }

    private static boolean hasRecipent(KeyTransRecipientInfo inf, byte[] subjectPubKeyID, X500Name recipientIssuer, BigInteger recipientSN) {
        RecipientIdentifier id = inf.getRecipientIdentifier();
        DEROctetString oct = new DEROctetString(subjectPubKeyID);
        IssuerAndSerialNumber issu = new IssuerAndSerialNumber(recipientIssuer, recipientSN);
        return id.getId().toASN1Primitive().asn1Equals((ASN1Primitive)oct) || id.getId().toASN1Primitive().asn1Equals(issu.toASN1Primitive());
    }
}

