package com.fshows.msfpay.response;

import com.fshows.msfpay.response.item.MsfpayFeeSubsidyRuleItemResponse;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * CAS016-条码支付响应
 */
@Data
public class MsfpayBarcodePayResponse extends MsfpayBizResponse {

    /**
     * 商户号
     * 必填: 是
     * 长度: 12
     */
    private String merid;

    /**
     * 支付信息
     * 必填: 否
     * 长度: 256
     * 1：扫码支付返回二维码信息
     * 2：公众号/小程序支付时,返回支付json串,作为微信支付API的参数
     * 3：支付宝间连模式下需去掉前两位后即可用于拉起支付宝支付
     * 4：云微小程序返回云闪付小程序ID、云闪付小程序path
     */
    private String payinfo;

    /**
     * 交易金额
     * 必填: 是
     * 长度: 16,2
     */
    private BigDecimal tranamt;

    /**
     * 扩展字段
     * 必填: 否
     * 长度: 600
     */
    private String extendfield;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     */
    private String prno;

    /**
     * 平台手续费
     * 必填: 是
     * 长度: 16,2
     * 以元单位，小数部分四舍五入保留2位小数
     */
    private BigDecimal patfee;

    /**
     * 手续费补贴总金额
     * 必填: 否
     * 长度: 16,2
     * 单位：元
     */
    private BigDecimal feeSubsidyAmtTotal;

    /**
     * 手续费补贴明细
     * 必填: 否
     * 长度: 1024
     * json格式
     */
    private List<MsfpayFeeSubsidyRuleItemResponse> feeSubsidyDetail;

    /**
     * 支付银行类型
     * 必填: 否
     * 长度: 32
     * 同微信和支付宝如ICBC_DEBIT
     */
    private String banktype;

    /**
     * 卡类型
     * 必填: 否
     * 长度: 2
     * 01 借记
     * 02 贷记
     */
    private String bankCardType;

    /**
     * 渠道订单号
     * 必填: 否
     * 长度: 32
     */
    private String chlOrderId;

    /**
     * 渠道完成时间
     * 必填: 否
     * 长度: 18
     * yyyyMMddHHmmssSSS
     */
    private String chlFinishTime;

    /**
     * 有效结算金额
     * 必填: 否
     * 长度: 16,2
     * 交易金额-免充值优惠金额，单位：元
     */
    private BigDecimal settleAmt;

    /**
     * 优惠金额
     * 必填: 否
     * 长度: 16,2
     * 单位：元
     */
    private BigDecimal couponAmt;

    /**
     * 支付用户标识
     * 必填: 否
     * 长度: 64
     * 购买者的微信openid/支付宝userid
     */
    private String openId;

    /**
     * 优惠详情
     * 必填: 否
     * 长度: 1024
     * JSON格式的优惠详情
     */
    private String promotionDetail;

    /**
     * 支付方式
     * 必填: 否
     * 长度: 32
     * 同支付下单
     */
    private String paytype;

    /**
     * 交易完成时间
     * 必填: 否
     * 长度: 17
     * 订单生成时间，格式为yyyyMMddHHmmssSSS
     */
    private String finishtime;

    /**
     * 手续费
     * 必填: 否
     * 长度: 16,2
     * 单位：元
     */
    private BigDecimal feeAmt;
}
