package com.fshows.msfpay.response;

import com.fshows.msfpay.response.item.MsfpayFeeSubsidyDetailItemResponse;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * CAS030-协议支付响应
 */
@Data
public class MsfpayAgreementPayResponse extends MsfpayBizResponse {

    /**
     * 商户名称
     * 必填: 是
     * 长度: 12
     */
    private String merid;

    /**
     * 交易金额
     * 必填: 是
     * 长度: 16,2
     * 说明: 银行卡被扣费的金额,保留小数2位。整数位最大为14位。
     */
    private BigDecimal tranamt;

    /**
     * 扩展字段
     * 必填: 否
     * 长度: 600
     */
    private String extendfield;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     */
    private String prno;

    /**
     * 手续费补贴总金额
     * 必填: 否
     * 长度: 16,2
     * 说明: 单位：元
     */
    private BigDecimal feeSubsidyAmtTotal;

    /**
     * 手续费补贴明细
     * 必填: 否
     * 长度: 1024
     * 说明: json格式，示例：[{"activityCode":"MkT1","couponCode":"MAC1","feeSubsidyAmt":0.01},{"activityCode":"MkT2","couponCode":"MAC2","feeSubsidyAmt":0.01}]
     * 对应对象: MsfpayFeeSubsidyDetailItemResponse
     */
    private List<MsfpayFeeSubsidyDetailItemResponse> feeSubsidyDetail;

    /**
     * 平台手续费
     * 必填: 是
     * 长度: 16,2
     * 说明: 以元单位，小数部分四舍五入保留2位小数.
     */
    private BigDecimal patfee;
}
