package com.fshows.msfpay.request.item;

import lombok.Data;

/**
 * 手续费补贴费率明细项
 */
@Data
public class MsfpayFeeSubsidyRuleItemRequest {

    /**
     * 活动编码
     * 必填: 是
     * 长度: 32
     * 示例: MKT1000000000
     */
    private String activityCode;

    /**
     * 支付方式
     * 必填: 是
     * 长度: 20
     * 示例: QUICKPAY
     * 说明: 支付方式类型
     */
    private String payType;

    /**
     * 补贴比例
     * 必填: 是
     * 长度: 10
     * 示例: 0.1
     * 说明: 补贴比例，如0.1表示10%
     */
    private String subsidyRatio;
} 