package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CAS062-查询提现明细数据请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayWithdrawDetailQueryRequest extends MsfpayBizRequest {

    /**
     * 商户id
     * 必填: 否
     * 长度: 12
     * 说明: 二级商户号或平台商户号，查平台商户下所有商户数据时，该字段不传
     */
    private String merid;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 32
     * 说明: 项目编号不为空时，商户id必传
     */
    private String prno;

    /**
     * 提现日期
     * 必填: 是
     * 长度: 32
     * 说明: yyyyMMdd 如 2025.06.10，则传20250610
     */
    @NotBlank(message = "提现日期不能为空")
    private String settledate;

    /**
     * 提现开始日期
     * 必填: 否
     * 长度: 32
     * 说明: 格式同上，该字段为空时根据"提现日期"查询，该字段不为空时根据区间段查询，最多支持一个月
     */
    private String settleBeginDate;
}
