package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * CMS042-二级商户结算周期和自动提现预留金额设置修改请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpaySettlementConfigModifyRequest extends MsfpayBizRequest {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "中投商户号不能为空")
    private String merid;

    /**
     * 修改类型
     * 必填: 是
     * 长度: 2
     * 说明: 01：修改结算周期 02：修改预留金额 03：修改提现设置
     */
    @NotBlank(message = "修改类型不能为空")
    private String modifyType;

    /**
     * 结算周期
     * 必填: 否
     * 长度: 2
     * 说明: 取值：T1、D1、D0:D0定时、D0R:D0秒结，modifyType为01时必填
     */
    private String settlePeriod;

    /**
     * 预留金额
     * 必填: 否
     * 长度: 14,2
     * 说明: 按余额自动提现时生效，modifyType为02时必填
     */
    private BigDecimal keepAmt;

    /**
     * 提现设置类型
     * 必填: 否
     * 说明: modifyType为03时必填；0：按账单自动提现；1：按余额自动提现；2：商户手动提现
     */
    private String autoCashoutBy;

    /**
     * 备注
     * 必填: 否
     * 长度: 128
     */
    private String remark;

    /**
     * 费率参数
     * 必填: 否
     * 长度: 2000
     * 说明: json格式字符串，参考CMS014接口费率格式，此处费率交易码只支持CAS010、CAS048
     * 对应对象: MsfpayMerRateItemRequest
     */
    private String merratelist;
}
