package com.fshows.msfpay.request;

import com.fshows.msfpay.request.item.MsfpayProductItemListRequest;
import com.fshows.msfpay.request.item.MsfpayProfitItemListRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * CAS063-快捷收银台下单请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayQuickCashierOrderRequest extends MsfpayBizRequest {

    /**
     * 商户id
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "商户id不能为空")
    private String merid;

    /**
     * 商户订单号
     * 必填: 是
     * 长度: 32
     */
    @NotBlank(message = "商户订单号不能为空")
    private String custorderid;

    /**
     * 客户号
     * 必填: 是
     * 长度: 30
     */
    @NotBlank(message = "客户号不能为空")
    private String custid;

    /**
     * 指定银行
     * 必填: 否
     * 长度: 32
     * 说明: 银行码
     */
    private String bankcode;

    /**
     * 指定卡类型
     * 必填: 否
     * 长度: 2
     * 说明: 01借记卡 02贷记卡
     */
    private String bankcardtype;

    /**
     * 客户信息是否加密
     * 必填: 是
     * 长度: 100
     * 说明: 01是 02否
     */
    @NotBlank(message = "客户信息是否加密不能为空")
    private String custinfoenc;

    /**
     * 客户姓名
     * 必填: 是
     * 长度: 100
     * 说明: 客户信息加密：sha1Hex加密
     */
    @NotBlank(message = "客户姓名不能为空")
    private String accountname;

    /**
     * 客户证件类型
     * 必填: 是
     * 长度: 100
     * 说明: 01身份证，客户信息加密：sha1Hex加密
     */
    @NotBlank(message = "客户证件类型不能为空")
    private String certtype;

    /**
     * 客户证件号
     * 必填: 是
     * 长度: 100
     * 说明: 客户信息加密：sha1Hex加密
     */
    @NotBlank(message = "客户证件号不能为空")
    private String certno;

    /**
     * 交易金额
     * 必填: 是
     * 长度: 14,2
     * 说明: 以元单位， 银行卡被扣费的金额,保留小数2位。整数位最大为14位。
     */
    @NotNull(message = "交易金额不能为空")
    private BigDecimal tranamt;

    /**
     * 平台手续费
     * 必填: 是
     * 长度: 14,2
     * 说明: 平台商户开通之后三方平台会告知订单收费规则按照三方指定的收费规则计算上送。当平台商户配置关闭分账功能后非必输,此时输入无效
     */
    @NotNull(message = "平台手续费不能为空")
    private BigDecimal patfee;

    /**
     * 分账类型
     * 必填: 是
     * 长度: 2
     * 说明: 见附件，当平台商户配置关闭分账功能后非必输,此时输入无效
     */
    @NotBlank(message = "分账类型不能为空")
    private String profittype;

    /**
     * 分账信息
     * 必填: 是
     * 长度: 255
     * 说明: {"profitlist":[{"merid":"CF3000038556","proportion":"0.8","prno":"1000000001"},{"merid":"CF3000038508","proportion":"0.2","prno":"1000000001"}]}
     * 对应对象: MsfpayProfitItemListRequest
     * prno为项目编号,非必输。当平台商户配置关闭分账功能后非必输,此时输入无效
     */
    @NotNull(message = "分账信息不能为空")
    private MsfpayProfitItemListRequest profitlist;

    /**
     * 商品信息
     * 必填: 是
     * 长度: 255
     * 说明: {"productlist":[{"productname":"牙刷","productnum":"2","productamt":"0.5"},{"productname":"电脑","productnum":"2","productamt":"4000"}]}
     * 对应对象: MsfpayProductItemListRequest
     * productname为商品名称，productnum为商品数量，productamt为商品金额
     */
    @NotNull(message = "商品信息不能为空")
    private MsfpayProductItemListRequest productlist;

    /**
     * 订单超时时间
     * 必填: 否
     * 长度: 2
     * 说明: 1-30之间（含）的正整数，单位为分钟默认30分钟
     */
    private Integer orderexpiretime;

    /**
     * 服务器回调地址
     * 必填: 否
     * 长度: 128
     * 说明: 订单成功之后作为服务器回调的地址
     */
    private String serverurl;

    /**
     * 扩展字段
     * 必填: 否
     * 长度: 100
     */
    private String extendfield;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     */
    private String prno;
}
