package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CAS045-优惠券取消请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayCouponCancelRequest extends MsfpayBizRequest {

    /**
     * 商户id
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "商户id不能为空")
    private String merid;

    /**
     * 优惠交易码
     * 必填: 是
     * 长度: 6
     * 说明: 获取优惠时的交易码 CAS002： 快捷支付；CAS030：协议支付
     */
    @NotBlank(message = "优惠交易码不能为空")
    private String coupontrancode;

    /**
     * 优惠标识
     * 必填: 是
     * 长度: 32
     */
    @NotBlank(message = "优惠标识不能为空")
    private String coupontoken;
}
