package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * CMS023-商户信息修改请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayMerchantInfoModifyRequest extends MsfpayBizRequest {

    /**
     * 商户id
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "商户id不能为空")
    private String merid;

    /**
     * 商户信息
     * 必填: 是
     * 长度: 256
     * 说明: 根据客户类型选择上传不同类型的商户信息，JSON格式
     * 企业商户：MsfpayEnterpriseMerchantRequest
     * 个体工商户：MsfpayIndividualBusinessRequest
     * 小微商户: MsfpayMicroMerchantRequest
     */
    @NotNull(message = "商户信息不能为空")
    private Object merinfos;
}
