package com.fshows.msfpay.client.model;

import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import lombok.Data;

/**
 * 中投科信支付配置模型
 */
@Data
public class MsfpayImgClientConfigModel extends DefaultClientConfigModel {

    /**
     * 商户号
     * 服务商id/平台商户号,一般以CF开头
     */
    private String platmerid;

    /**
     * 签名类型 cert/sm2
     * cert: RSA算法
     * sm2: SM2算法
     */
    private String signType = "sm2";

    /**
     * 字符集
     */
    private String charset = "UTF-8";

    /**
     * 接口版本
     */
    private String version = "1.0.0";

    /**
     * 请求超时时间（毫秒）
     */
    private int timeout = 30000;

    /**
     * 商户签名密钥路径
     */
    private String merchantSignPath;

    /**
     * 商户签名密钥密码
     */
    private String merchantSignPwd;

    /**
     * 商户加密密钥路径
     */
    private String merchantEncPath;

    /**
     * 商户加密密钥密码
     */
    private String merchantEncPwd;

    /**
     * 平台加密证书路径
     */
    private String platformEncCertPath;

    /**
     * 平台签名证书路径
     */
    private String platformSignCertPath;
}