package com.fshows.msfpay.response.item;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @author songjian * @version MsfpayInstallmentFeeInfoResponse.java, v 0.1 2025-08-06 19:56 songjian
 */
@Data
public class MsfpayInstallmentFeeInfoResponse {
    /**
     * 分期手续费类型
     * 必填: 是
     * 长度: 32
     * 说明: 02-分期收取
     */
    public String instalFeeType;

    /**
     * 分期期数
     * 必填: 是
     * 长度: 6
     * 说明: 3/6/12
     */
    public String instalNum;

    /**
     * 每期还款金额
     * 必填: 是
     * 类型: Number
     * 长度: 16,2
     * 单位: 元
     */
    public BigDecimal perAmount;

    /**
     * 每期服务费
     * 必填: 是
     * 类型: Number
     * 长度: 16,2
     * 单位: 元
     */
    public BigDecimal perFee;

    /**
     * 还款金额
     * 必填: 是
     * 类型: Number
     * 长度: 16,2
     * 单位: 元
     */
    public BigDecimal returnAmount;

    /**
     * 总还款金额
     * 必填: 是
     * 类型: Number
     * 长度: 16,2
     * 单位: 元
     */
    public BigDecimal totalAmount;

    /**
     * 总期数服务费
     * 必填: 是
     * 类型: Number
     * 长度: 16,2
     * 单位: 元
     */
    public BigDecimal totalFee;

    /**
     * 年化利率
     * 必填: 是
     * 长度: 8
     * 说明: 相同期数利率一致
     */
    public String irr;
}
