package com.fshows.msfpay.request.item;

import lombok.Data;

/**
 * 分账金额信息项
 */
@Data
public class MsfpayProfitAmtItemRequest {

    /**
     * 商户号
     * 必填: 是
     * 长度: 12
     * 示例: CM3000047819
     */
    private String merid;

    /**
     * 分账金额
     * 必填: 是
     * 长度: 16,2
     * 示例: 0.1
     * 说明: 以元为单位，保留小数2位
     */
    private String profitamt;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     * 示例: 1000000001
     * 说明: 项目编号，非必输
     */
    private String prno;
} 