package com.fshows.msfpay.request.item;

import lombok.Data;

/**
 * 商品详情项
 * 用于微信单品优惠活动
 */
@Data
public class MsfpayGoodsDetailItemRequest {

    /**
     * 商品编码
     * 必填: 是
     * 长度: 32
     * 说明: 商户定义的商品编码
     */
    private String goodsId;

    /**
     * 微信支付商品编码
     * 必填: 否
     * 长度: 32
     * 说明: 微信支付定义的统一商品编号（没有可不传）
     */
    private String wxPayGoodsId;

    /**
     * 商品名称
     * 必填: 是
     * 长度: 256
     * 说明: 商品的实际名称
     */
    private String goodsName;

    /**
     * 商品数量
     * 必填: 是
     * 说明: 商品的数量
     */
    private Integer quantity;

    /**
     * 商品单价
     * 必填: 是
     * 说明: 商品单价，单位为分
     */
    private Long price;
}
