package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CAS059-银联授权码获取用户userid请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayUnionPayAuthCodeRequest extends MsfpayBizRequest {

    /**
     * 授权码
     * 必填: 是
     * 长度: 64
     */
    @NotBlank(message = "授权码不能为空")
    private String userAuthCode;

    /**
     * 银联支付标识
     * 必填: 是
     * 长度: 32
     * 说明: 从userAgent中获取的银联支付标识，格式为"UnionPay/<版本号> <App标识>"，APP标识仅支持字母和数字。
     *       示例：UnionPay/1.0 CloudPay 、 UnionPay/1.0 PABANK
     */
    @NotBlank(message = "银联支付标识不能为空")
    private String appUpIdentifier;
}
