package com.fshows.msfpay.response;

import com.fshows.msfpay.response.item.MsfpayFeeSubsidyDetailItemResponse;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * CAS006-退款响应
 */
@Data
public class MsfpayRefundResponse extends MsfpayBizResponse {

    /**
     * 退款金额
     * 必填: 是
     * 长度: 16,2
     */
    private BigDecimal refundamt;

    /**
     * 退款状态
     * 必填: 是
     * 长度: 2
     * 说明: 01：商户申请成功 40：退款成功 41：退款失败
     */
    private String status;

    /**
     * 扩展字段
     * 必填: 否
     * 长度: 600
     */
    private String extendfield;

    /**
     * 有效结算金额
     * 必填: 否
     * 长度: 16,2
     * 说明: 退款金额-免充值优惠金额 单位：元
     */
    private BigDecimal settleAmt;

    /**
     * 优惠金额
     * 必填: 否
     * 长度: 16,2
     * 说明: 单位：元
     */
    private BigDecimal couponAmt;

    /**
     * 返还手续费
     * 必填: 否
     * 长度: 16,2
     * 说明: 单位：元（返还补贴手续费+返还商户手续费）
     */
    private BigDecimal returnFee;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     */
    private String prno;

    /**
     * 返还手续费补贴总金额
     * 必填: 否
     * 长度: 16,2
     * 说明: 单位：元
     */
    private BigDecimal feeSubsidyAmtTotal;

    /**
     * 返还手续费补贴明细
     * 必填: 否
     * 长度: 1024
     * 说明: json格式，示例：[{"activityCode":"MkT1","couponCode":"MAC1","feeSubsidyAmt":0.01},{"activityCode":"MkT2","couponCode":"MAC2","feeSubsidyAmt":0.01}]
     * 对应对象: List<MsfpayFeeSubsidyDetailItemResponse>
     */
    private List<MsfpayFeeSubsidyDetailItemResponse> feeSubsidyDetail;
}
