package com.fshows.msfpay.response;

import com.fshows.msfpay.response.item.MsfpayQuotaItemResponse;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * CAS011-账户余额查询响应
 */
@Data
public class MsfpayAccountBalanceQueryResponse extends MsfpayBizResponse {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    private String merid;

    /**
     * 中投商户名称
     * 必填: 是
     * 长度: 20
     */
    private String mername;

    /**
     * 账户余额
     * 必填: 是
     * 长度: 16,2
     * 说明: 即：现金账户余额
     */
    private BigDecimal balance;

    /**
     * 当日在途资金
     * 必填: 是
     * 长度: 16,2
     * 说明: 即：待清算账户余额 (不包含昨日在途资金)
     */
    private BigDecimal transitfunds;

    /**
     * 客户状态
     * 必填: 是
     * 长度: 2
     * 说明: 0：正常  1：冻结  2：注销  3：待审核  4：审核失败 5：未签约  6:止付  9:止入
     */
    private String status;

    /**
     * 账户号码
     * 必填: 是
     * 长度: 32
     */
    private String accountno;

    /**
     * 账户名称
     * 必填: 是
     * 长度: 128
     */
    private String accountname;

    /**
     * 签约时间
     * 必填: 否
     * 长度: 14
     * 说明: yyyyMMddHHmmss
     */
    private String agreeTime;

    /**
     * 签约生效时间
     * 必填: 否
     * 长度: 8
     * 说明: yyyyMMdd
     */
    private String agreementStartTime;

    /**
     * 协议文件获取地址
     * 必填: 否
     * 长度: 128
     */
    private String agreementfileurl;

    /**
     * 手续费欠账账户金额
     * 必填: 否
     * 长度: 16,2
     * 说明: 平台商户必输，欠费金额以负值展示
     */
    private BigDecimal feeacctbalance;

    /**
     * 商户手续费集合
     * 必填: 否
     * 长度: 600
     * 说明: 签约时上送的二级商户费率列表
     * 对应对象: MsfpayMerRateItemResponse
     */
    private String merratelist;

    /**
     * 冻结账户余额
     * 必填: 是
     * 长度: 16,2
     * 说明: 数值一般为当日结算金额，到结算点时，会转入现金账户(体现在账户余额)
     */
    private BigDecimal freezeamt;

    /**
     * 是否开通额度
     * 必填: 是
     * 长度: 2
     * 说明: "quotas":[{"applybus":"CAS024","state":"02"},{"applybus":"CAS025","state":"01"}]
     * 对应对象: MsfpayQuotaItemListResponse
     * 注：applybus：交易码 state： 00：待审核 01：已开通 02：未开通 03：已经禁用
     */
    private List<MsfpayQuotaItemResponse> quotas;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     */
    private String prno;

    /**
     * 项目名称
     * 必填: 否
     * 长度: 128
     */
    private String prname;

    /**
     * 总账户余额
     * 必填: 否
     * 长度: 16,2
     */
    private BigDecimal totalbalance;
}
