package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CAS054-查询结算明细数据请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpaySettlementDetailQueryRequest extends MsfpayBizRequest {

    /**
     * 商户id
     * 必填: 否
     * 长度: 12
     * 说明: 二级商户号或平台商户号，查平台商户下所有商户数据时，该字段不传
     */
    private String merid;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 32
     * 说明: 项目编号不为空时，商户id必传
     */
    private String prno;

    /**
     * 结算日期
     * 必填: 是
     * 长度: 32
     * 说明: yyyyMMdd 如 2023.12.18结算，则传20231218
     */
    @NotBlank(message = "结算日期不能为空")
    private String settledate;
}
