package com.fshows.msfpay.request;

import com.fshows.msfpay.request.item.MsfpayProductItemListRequest;
import com.fshows.msfpay.request.item.MsfpayProfitItemListRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * CAS046-转账支付请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayTransferPayRequest extends MsfpayBizRequest {

    /**
     * 商户id
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "商户id不能为空")
    private String merid;

    /**
     * 交易金额
     * 必填: 是
     * 长度: 16,2
     * 说明: 银行卡被扣费的金额,保留小数2位。整数位最大为14位。
     */
    @NotNull(message = "交易金额不能为空")
    private BigDecimal tranamt;

    /**
     * 服务器通知地址码
     * 必填: 是
     * 长度: 128
     */
    @NotBlank(message = "服务器通知地址不能为空")
    private String serverurl;

    /**
     * 平台手续费
     * 必填: 是
     * 长度: 16,2
     * 说明: 1、平台商户开通之后三方平台会告知订单收费规则按照三方指定的收费规则计算上送。2、该手续费值只做规则和算法校验用，实际收费以后台为准3、后收费时该值必须为0。当平台商户配置关闭分账功能后非必输,此时输入无效
     */
    @NotNull(message = "平台手续费不能为空")
    private BigDecimal patfee;

    /**
     * 分账类型
     * 必填: 是
     * 长度: 2
     * 说明: 00 按比例账 01 按金额分账。当平台商户配置关闭分账功能后非必输,此时输入无效
     */
    @NotBlank(message = "分账类型不能为空")
    private String profittype;

    /**
     * 分账信息
     * 必填: 是
     * 长度: 255
     * 说明: {"profitlist":[{"merid":"CF3000038556","proportion":"0.8","prno":"1000000001"},{"merid":"CF3000038508","proportion":"0.2","prno":"1000000001"}]}
     * 对应对象: MsfpayProfitItemListRequest
     * prno为项目编号,非必输。当平台商户配置关闭分账功能后非必输,此时输入无效
     */
    @NotNull(message = "分账信息不能为空")
    private MsfpayProfitItemListRequest profitlist;

    /**
     * 商品信息
     * 必填: 是
     * 长度: 255
     * 说明: {"productlist":[{"productname":"牙刷","productnum":"2","productamt":"0.5"},{"productname":"电脑","productnum":"2","productamt":"4000"}]}
     * 对应对象: MsfpayProductItemListRequest
     * productname为商品名称，productnum为商品数量，productamt为商品金额
     */
    @NotNull(message = "商品信息不能为空")
    private MsfpayProductItemListRequest productlist;

    /**
     * 备注
     * 必填: 否
     * 长度: 200
     */
    private String remark;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     */
    private String prno;

    /**
     * 匹配方式
     * 必填: 否
     * 长度: 12
     * 说明: PYE:收款账户 RMK:备注
     */
    private String matchmode;
}
