package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CMS041-二级商户项目管理请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayProjectManageRequest extends MsfpayBizRequest {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "中投商户号不能为空")
    private String merid;

    /**
     * 操作类型
     * 必填: 是
     * 长度: 2
     * 说明: 01：新增 02：终止 03：换绑卡 04：修改 05：查询
     */
    @NotBlank(message = "操作类型不能为空")
    private String type;

    /**
     * 项目名称
     * 必填: 否
     * 长度: 128
     * 说明: 操作为01时必输
     */
    private String prname;

    /**
     * 项目编号
     * 必填: 是
     * 长度: 128
     * 说明: 商户为项目分配的唯一编码
     */
    @NotBlank(message = "项目编号不能为空")
    private String prno;

    /**
     * 账户类型
     * 必填: 否
     * 长度: 2
     * 说明: 操作为03时必输 00：对私账户 01：对公账户
     */
    private String accounttype;

    /**
     * 账户号码
     * 必填: 否
     * 长度: 32
     * 说明: 操作为03时必输
     */
    private String accountno;

    /**
     * 账户名称
     * 必填: 否
     * 长度: 128
     * 说明: 操作为03时必输 个体：需与经营者姓名一致 企业、小微：需与商户名称一致
     */
    private String accountname;

    /**
     * 银行名称
     * 必填: 否
     * 长度: 128
     * 说明: 对公账户必输
     */
    private String bankname;

    /**
     * 银行代码
     * 必填: 否
     * 长度: 8
     * 说明: 对公账户必输
     */
    private String bankcode;

    /**
     * 开户所在省
     * 必填: 否
     * 长度: 20
     * 说明: 对公账户必输，不带"省"或"自治区"，如 湖南，北京，内蒙古等
     */
    private String bankpro;

    /**
     * 开户所在市
     * 必填: 否
     * 长度: 30
     * 说明: 对公账户必输，不带"市"字如北京
     */
    private String bankcity;

    /**
     * 所属分支行
     * 必填: 否
     * 长度: 32
     */
    private String branch;
}
