package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CMS060-自定义分账业务申请请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayCustomSplitApplyRequest extends MsfpayBizRequest {

    /**
     * 申请商户号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "申请商户号不能为空")
    private String merid;

    /**
     * 操作类型
     * 必填: 是
     * 长度: 2
     * 说明: 01：开通（支持开通自定义分账业务、绑定及修改分账目标会员及银行账户信息。)
     *       02：关闭（支持关闭该申请商户号的自定义分账业务）
     */
    @NotBlank(message = "操作类型不能为空")
    private String optype;

    /**
     * 申请分账比例
     * 必填: 否
     * 长度: 3
     * 说明: 百分比，不传默认100
     */
    private String ratio;

    /**
     * 分账会员信息
     * 必填: 是
     * 长度:
     * 说明: 企业/个人户/个人，详情见下文
     * 企业：MsfpayEnterpriseRequest
     * 个人户：MsfpayIndividualResponse
     * 个人：MsfpayPersonalRequest
     */
    private Object merinfos;


}
