package com.fshows.msfpay.request.item;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @author songjian * @version MsfpayModContentRequest.java, v 0.1 2025-08-06 20:10 songjian
 */
@Data
public class MsfpayModContentRequest {
    /**
     * 红包编码
     * 必填: 是
     * 长度: 32
     */
    public String couponCode;

    /**
     * 红包面额
     * 必填: 否
     * 类型: NUMBER
     * 精度: 16,2
     */
    public BigDecimal couponAmt;

    /**
     * 有效期开始时间
     * 必填: 否
     * 长度: 32
     * 格式: yyyyMMddHHmmss
     */
    public String startTime;

    /**
     * 有效期截止日期
     * 必填: 否
     * 长度: 32
     * 格式: yyyyMMddHHmmss
     */
    public String endTime;

    /**
     * 状态
     * 必填: 否
     * 说明: USABLE:可用,DISABLE:停用,EXPIRED:过期
     */
    public String state;
}
