package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CMS051-二级商户项目账户管理请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayProjectAccountManageRequest extends MsfpayBizRequest {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "中投商户号不能为空")
    private String merid;

    /**
     * 操作类型
     * 必填: 是
     * 长度: 2
     * 说明: 01：新增 04：修改 05：查询
     */
    @NotBlank(message = "操作类型不能为空")
    private String type;

    /**
     * 项目名称
     * 必填: 否
     * 长度: 128
     * 说明: 操作为01时必输
     */
    private String prname;

    /**
     * 项目编号
     * 必填: 是
     * 长度: 128
     * 说明: 商户为项目分配的唯一编码
     */
    @NotBlank(message = "项目编号不能为空")
    private String prno;

    /**
     * 所属分支行
     * 必填: 否
     * 长度: 32
     */
    private String branch;
}
