package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CAS049-会员分账交易状态查询请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayMemberSplitQueryRequest extends MsfpayBizRequest {

    /**
     * 商户编号
     * 必填: 是
     * 长度: 12
     * 说明: 支持平台商户与二级商户
     */
    @NotBlank(message = "商户编号不能为空")
    private String merid;

    /**
     * 原交易流水号
     * 必填: 是
     * 长度: 32
     */
    @NotBlank(message = "原交易流水号不能为空")
    private String oritranflow;
}
