package com.fshows.msfpay.response;

import lombok.Data;

/**
 * CMS060-自定义分账业务申请响应
 */
@Data
public class MsfpayCustomSplitApplyResponse extends MsfpayBizResponse {

    /**
     * 申请商户号
     * 必填: 是
     * 长度: 12
     */
    private String merid;

    /**
     * 操作类型
     * 必填: 是
     * 长度: 2
     */
    private String optype;

    /**
     * 申请分账比例
     * 必填: 否
     * 长度: 3
     */
    private String ratio;

    /**
     * 分账目标会员号
     * 必填: 否
     * 长度: 12
     */
    private String targetMemUserId;

    /**
     * 申请状态
     * 必填: 是
     * 长度: 2
     * 说明: 00 已开通 01 待审核 02 审核拒绝 03 待签 04 已禁用 05 已过期 06 已失效
     */
    private String state;

    /**
     * 签约地址URL
     * 必填: 否
     * 长度: 256
     */
    private String linkUrl;
}
