package com.fshows.msfpay.request.item;

import lombok.Data;

/**
 * @author songjian * @version MsfpayIndividualBusinessRequest.java, v 0.1 2025-08-06 19:31 songjian
 */
@Data
public class MsfpayIndividualBusinessRequest {
    /**
     * 营业执照号
     * 必填: 是
     * 长度: 20
     */
    public String businessLicenseNo;

    /**
     * 营业执照照片
     * 必填: 是
     * 长度: 128
     * 说明: 1、企业商户、个体工商户上送；2、注册时可不上送，需按风控要求时效内补交
     */
    public String businessLicensePhoto;

    /**
     * 经营者姓名
     * 必填: 是
     * 长度: 32
     * 说明: 个体商户结算卡只能绑定该姓名下的银行卡
     */
    public String managerName;

    /**
     * 经营者证件类型
     * 必填: 是
     * 长度: 2
     * 说明: 身份证、港澳居民来往内地通行证、台湾居民来往大陆通行证、外国公民护照
     */
    public String managerCertType;

    /**
     * 经营者证件号码
     * 必填: 是
     * 长度: 22
     */
    public String managerId;

    /**
     * 经营者地址
     * 必填: 是
     * 长度: 10-120
     * 说明: 证件类型"身份证"：输入身份证上的地址；证件类型非身份证：输入经营者在大陆地区的联系地址
     */
    public String managerAddr;

    /**
     * 经营者证件有效期开始日期
     * 必填: 是
     * 长度: 8
     * 说明: 格式：yyyymmdd，"证件有效期开始日期"小于等于当前入网日期
     */
    public String managerIdValidBegin;

    /**
     * 经营者身份证有效期
     * 必填: 是
     * 长度: 8
     * 说明: 长期: 99991231，格式：yyyymmdd，"经营者证件有效期截止日期"大于等于当前入网日期；"经营者证件有效期截止日期"大于"经营者证件有效期开始日期"
     */
    public String managerIdValid;

    /**
     * 经营者证件正面照
     * 必填: 是
     * 长度: 128
     */
    public String managerIdPhoto;

    /**
     * 经营者证件反面照
     * 必填: 是
     * 长度: 128
     */
    public String managerIdBackPhoto;

    /**
     * 经营者结算银行卡照片
     * 必填: 否
     * 长度: 128
     * 说明: 1.个体工商户上送；2.可根据情况选择性上送；3、照片要求包含银行卡正反面
     */
    public String managerHandleBankPhoto;

    /**
     * 专营资质行业信息
     * 必填: 否
     * 长度: 1000
     * 说明: 商户根据情况选择性上送
     */
    public String franchisedLicences;

    /**
     * 专营资质证件影像压缩文件
     * 必填: 否
     * 长度: 128
     * 说明: 仅支持压缩文件
     */
    public String franchisedLicencePhotoZip;

    /**
     * 门头照
     * 必填: 是
     * 长度: 128
     */
    public String storePhoto;

    /**
     * 内部经营照
     * 必填: 是
     * 长度: 128
     */
    public String storeInsidePhoto;

    /**
     * 经营者于经营场所手持营业执照/身份证照片
     * 必填: 否
     * 长度: 128
     * 说明: 仅支持图片
     */
    public String managerHandleIdPhoto;

    /**
     * 其他照片
     * 必填: 否
     */
    public String otherPhoto;

    /**
     * 商户网站地址
     * 必填: 否
     * 长度: 128
     */
    public String merchantUrl;

    /**
     * 银行账户开户证明文件
     * 必填: 否
     * 长度: 128
     * 说明: 具体开户证明文件可登录"中投科信支付"公众号-常见问题中查阅
     */
    public String openingNoPhoto;

    /**
     * ICP许可证号/ICP备案号
     * 必填: 否
     * 长度: 128
     */
    public String icpNo;

    /**
     * ICP许可证/ICP备案有效期
     * 必填: 否
     * 长度: 128
     * 说明: 长期: 9999/12/31
     */
    public String icpValid;

    /**
     * 开户声明文件
     * 必填: 否
     * 长度: 128
     * 说明: 仅支持图片，(法定代表人亲笔签名+加盖公章)原件；附《开户声明文件模板》
     */
    public String declaraPhoto;

    /**
     * 开户意愿视频
     * 必填: 否
     * 长度: 128
     * 说明: 仅支持mp4、mov视频格式，文件不大于10M；法定代表人在《开户声明》上签字的视频文件
     */
    public String wishVideo;
}
