package com.fshows.msfpay.request;

import com.fshows.msfpay.response.item.MsfpayMerchantInfoChangeItemRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CMS024-商户信息变更请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayMerchantInfoChangeRequest extends MsfpayBizRequest {

    /**
     * 商户id
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "商户id不能为空")
    private String merid;

    /**
     * 商户名称
     * 必填: 否
     * 长度: 256
     */
    private String corname;

    /**
     * 商户简称
     * 必填: 否
     * 长度: 20
     */
    private String shortname;

    /**
     * 经营地址
     * 必填: 否
     * 长度: 120
     * 说明: 长度10-120
     */
    private String managementaddress;

    /**
     * 联系人手机号
     * 必填: 否
     * 长度: 12
     * 说明: 商户类型为"单位"时，非必输；商户类型为"个体工商户"、"小微"时，必输。
     */
    private String phone;

    /**
     * 联系人邮箱
     * 必填: 否
     * 长度: 120
     */
    private String email;

    /**
     * 清算目标
     * 必填: 否
     * 长度: 2
     * 说明: 默认00（支付账户）
     */
    private String settletarget;

    /**
     * 清算周期
     * 必填: 否
     * 长度: 2
     * 说明: 目前只支持T+1（默认00）
     */
    private String settleperiod;

    /**
     * 商户归属项目
     * 必填: 否
     * 长度: 2
     * 说明: 00自有商户，01民生拓展商户，02其他
     */
    private String merBelong;

    /**
     * 商户拓展经理
     * 必填: 否
     * 长度: 128
     */
    private String custManager;

    /**
     * 商户拓展经理所属机构
     * 必填: 否
     * 长度: 128
     */
    private String custManagerOrg;

    /**
     * 服务器通知地址
     * 必填: 是
     * 长度: 128
     * 说明: 商户平台认证审核后通知地址
     */
    @NotBlank(message = "服务器通知地址不能为空")
    private String severurl;

    /**
     * 相关信息
     * 必填: 否
     * 长度: 1024
     * 说明: 更改商户名称时必填，根据商户类型，上送相关字段
     * MsfpayMerchantInfoChangeItemRequest
     */
    private MsfpayMerchantInfoChangeItemRequest supplyinfos;
}
