/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request.merchant;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;

/**
 * 机具报备接口 request
 *
 * @author
 * @version LzccbDeviceRegisterReq.java, v 0.1 2024-09-12 09:52:48
 */
@Data
public class LzccbMerchantStoreInfoReq implements Serializable {

    private static final long serialVersionUID = -96031659104550465L;
    /**
     * 门店名称
     */
    @NotBlank
    @Length(max = 64, message = "acctNo长度不能超过64")
    private String storeName;

    /**
     * 门店简称
     * 小于40个字节的字符串
     */
    @NotBlank
    @Length(max = 40, message = "storeBrief长度不能超过40")
    private String storeBrief;

    /**
     * 经营地址
     */
    @NotBlank
    @Length(max = 64, message = "address长度不能超过64")
    private String address;

    /**
     * 省编码
     */
    @NotBlank
    @Length(max = 6, message = "provinceCode长度不能超过6")
    private String provinceCode;

    /**
     * 城市编码
     */
    @NotBlank
    @Length(max = 6, message = "cityCode长度不能超过6")
    private String cityCode;

    /**
     * 区域编码
     */
    @NotBlank
    @Length(max = 6, message = "areaCode长度不能超过6")
    private String areaCode;

    /**
     * 纬度
     */
    @NotBlank
    @Length(max = 10, message = "latitude长度不能超过10")
    private String latitude;

    /**
     * 经度
     */
    @NotBlank
    @Length(max = 10, message = "longitude长度不能超过10")
    private String longitude;

    /**
     * 门店经营类型
     * OFFLINE--线下门店
     * ONLINE--线上门店
     * MINI -- 线上线下门店
     */
    @NotBlank
    @Length(max = 10, message = "mccType长度不能超过10")
    private String mccType;

    /**
     * 门头照url
     * 线下/线上线下门店必传。图片上传接口返回的token
     */
    @Length(max = 128, message = "headPic长度不能超过128")
    private String headPic;

    /**
     * 内景照
     * 线下/线上线下门店必传。图片上传接口返回的token
     */
    @Length(max = 128, message = "innerPic长度不能超过128")
    private String innerPic;

    /**
     * 细节照
     * 线下/线上线下门店必传。图片上传接口返回的token
     */
    @Length(max = 128, message = "detailPic长度不能超过128")
    private String detailPic;

    /**
     * 门店联系方式
     */
    @Length(max = 11, message = "phone长度不能超过11")
    private String phone;

    /**
     * 收银台照
     * 线下/线上线下门店必传。图片上传接口返回的token
     */
    @Length(max = 128, message = "cashierPic长度不能超过128")
    private String cashierPic;

    /**
     * 客户经理巡检照
     * 线下/线上线下门店必传。图片上传接口返回的token
     */
    @Length(max = 128, message = "inspectionPic长度不能超过128")
    private String inspectionPic;

    /**
     * 网络平台名称
     * 线上/线上线下门店必传
     */
    @Length(max = 64, message = "netPlatformName长度不能超过64")
    private String netPlatformName;

    /**
     * 网络平台url
     * 线上/线上线下门店必传
     */
    @Length(max = 128, message = "netPlatformUrl长度不能超过128")
    private String netPlatformUrl;

    /**
     * icp备案号
     * 线上/线上线下门店必传
     */
    @Length(max = 32, message = "icpNo长度不能超过32")
    private String icpNo;

    /**
     * ip信息
     * 线上/线上线下门店必传
     */
    @Length(max = 32, message = "netIp长度不能超过32")
    private String netIp;

    /**
     * 网络平台类型
     * 线上/线上线下门店必传
     */
    @Length(max = 32, message = "netType长度不能超过32")
    private String netType;

}