/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request.merchant;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;

/**
 * 机具报备接口 request
 *
 * @author
 * @version LzccbDeviceRegisterReq.java, v 0.1 2024-09-12 09:52:48
 */
@Data
public class LzccbMerchantSettleInfoReq implements Serializable {


    private static final long serialVersionUID = 8089018532167343307L;
    /**
     * 结算账户卡号
     */
    @NotBlank
    @Length(max = 22, message = "acctNo长度不能超过22")
    private String acctNo;

    /**
     * 结算账户户名
     */
    @NotBlank
    @Length(max = 32, message = "acctName长度不能超过32")
    private String acctName;

    /**
     * 结算账户预留手机号
     */
    @NotBlank
    @Length(max = 11, message = "phone长度不能超过11")
    private String phone;

    /**
     * 结算账户类型
     * PUBLIC--对公账户
     * DEBIT -- 储蓄账户/借记账户
     */
    @NotBlank
    @Length(max = 10, message = "type长度不能超过10")
    private String type;

    /**
     * 结算账户预留证件号
     */
    @NotBlank
    @Length(max = 18, message = "cerNo长度不能超过18")
    private String cerNo;

    /**
     * 清算行号
     */
    @NotBlank
    @Length(max = 15, message = "cnapsClearBankCode长度不能超过15")
    private String cnapsClearBankCode;

    /**
     * 开户行号
     */
    @Length(max = 15, message = "cnapsOpenBankCode长度不能超过15")
    private String cnapsOpenBankCode;

    /**
     * 卡等级
     * 1--1类卡
     * 2--2类卡
     */
    @Length(max = 1, message = "acctLevel长度不能超过1")
    private String acctLevel;

}