/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.request.merchant;

import com.fshows.request.LzccbBaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author mengqf
 * @version LzccbMerchantPayIndexBindReq.java, v 0.1 2025-08-26 15:31 mengqf
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class LzccbMerchantPayIndexBindReq extends LzccbBaseRequest {
    private static final long serialVersionUID = -2882953030001492132L;
    /**
     * 商户号
     */
    @NotBlank
    @Length(max = 32, message = "mchtNo长度不能超过32")
    private String mchtNo;
    /**
     * 微信支付目录
     */
    @NotBlank
    @Length(max = 128, message = "微信支付目录长度不能超过128")
    private String payIndex;
    /**
     * 渠道商编号
     */
    @NotBlank
    @Length(max = 32, message = "channelNo长度不能超过32")
    private String channelNo;
}