/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request.merchant;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;

/**
 * 机具报备接口 request
 *
 * @author
 * @version LzccbDeviceRegisterReq.java, v 0.1 2024-09-12 09:52:48
 */
@Data
public class LzccbMerchantInfoReq implements Serializable {

    private static final long serialVersionUID = 6248058573353689686L;

    /**
     * 平台商户号
     * 用于已进件商户的信息
     * 修改时上送
     */
    @Length(max = 32, message = "merchantNo长度不能超过32")
    private String merchantNo;

    /**
     * 商户全称
     * 有汉字，英文，数字，横线或下划线组成
     */
    @NotBlank
    @Length(max = 64, message = "mchtName长度不能超过64")
    private String mchtName;

    /**
     * 商户简称
     * 最多40个字节的字符数
     */
    @NotBlank
    @Length(max = 40, message = "brief长度不能超过40")
    private String brief;

    /**
     * 商户法人姓名
     */
    @NotBlank
    @Length(max = 32, message = "legalName长度不能超过32")
    private String legalName;

    /**
     * 商户法人证件号
     */
    @NotBlank
    @Length(max = 18, message = "legalCerNo长度不能超过18")
    private String legalCerNo;

    /**
     * 法人电话号码
     */
    @NotBlank
    @Length(max = 11, message = "legalPhone长度不能超过11")
    private String legalPhone;

    /**
     * 商户类型
     * MICRRO--小微商户
     * PERSON--个体商户
     * ENTERPRISE--企业商户
     * OTHER -- 其他商户
     * GOVERNMENT--政府商户
     * INSTITUTION--事业单位
     */
    @NotBlank
    @Length(max = 10, message = "type长度不能超过10")
    private String type;

    /**
     * 默认 MCHTCHANNEL
     */
    @NotBlank
    @Length(max = 10, message = "category长度不能超过10")
    private String category;

    /**
     * 商户经营类目
     */
    @NotBlank
    @Length(max = 4, message = "mccCode长度不能超过4")
    private String mccCode;

    /**
     * 商户地址
     * 省+市+区+详细地址
     */
    @NotBlank
    @Length(max = 64, message = "address长度不能超过64")
    private String address;

    /**
     * 省编码
     */
    @NotBlank
    @Length(max = 6, message = "provinceCode长度不能超过6")
    private String provinceCode;

    /**
     * 城市编码
     */
    @NotBlank
    @Length(max = 6, message = "cityCode长度不能超过6")
    private String cityCode;

    /**
     * 区域编码
     */
    @NotBlank
    @Length(max = 6, message = "areaCode长度不能超过6")
    private String areaCode;

    /**
     * 客户经理账号
     */
    @NotBlank
    @Length(max = 32, message = "customManager长度不能超过32")
    private String customManager;

    /**
     * 门店经营类型
     * OFFLINE--线下门店
     * ONLINE--线上门店
     * MINI -- 线上线下门店
     */
    @NotBlank
    @Length(max = 10, message = "mccType长度不能超过10")
    private String mccType;
}