/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request.merchant;

import com.fshows.request.LzccbBaseRequest;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;
import java.util.List;

/**
 * 机具报备接口 request
 *
 * @author
 * @version LzccbDeviceRegisterReq.java, v 0.1 2024-09-12 09:52:48
 */
@Data
public class LzccbMerchantIncomeReq extends LzccbBaseRequest implements Serializable {

    private static final long serialVersionUID = -7856808108978623351L;

    /**
     * 商户信息
     */
    private LzccbMerchantInfoReq merchantInfo;

    /**
     * 结算账户信息
     */
    private LzccbMerchantSettleInfoReq merchantSettleInfo;

    /**
     * 门店经营信
     */
    private LzccbMerchantStoreInfoReq storeInfo;

    /**
     * 商户证件资料
     * 结算卡账户资料必传
     * 必须上传身份证人像面，身份证国徽面。其中小微/其他商户，还须上传手持身份证照；个体/企业商户须上送营业执照，事业单位/政府机构虚上送PUBLICLEGAL附件
     */
    private List<LzccbMerchantAttachInfoReq> attachList;

    /**
     * 签约产品列表
     */
    private List<String> productNos;

    /**
     * 渠道商编号
     */
    @NotBlank
    @Length(max = 50, message = "channelNo长度不能超过50")
    private String channelNo;
}