/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.request.merchant;

import com.fshows.request.LzccbBaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author mengqf
 * @version LzccbMerchantAppidQueryReq.java, v 0.1 2025-08-26 16:14 mengqf
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class LzccbMerchantAppidQueryReq extends LzccbBaseRequest {
    private static final long serialVersionUID = 6722882563407909528L;
    /**
     * 商户号
     */
    @NotBlank
    @Length(max = 32, message = "mchtNo长度不能超过32")
    private String mchtNo;
    /**
     * 渠道商编号
     */
    @NotBlank
    @Length(max = 32, message = "channelNo长度不能超过32")
    private String channelNo;
}