/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.request.merchant;

import com.fshows.request.LzccbBaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author mengqf
 * @version LzccbMerchantAppidBindReq.java, v 0.1 2025-08-26 15:19 mengqf
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class LzccbMerchantAppidBindReq extends LzccbBaseRequest {
    private static final long serialVersionUID = -530846300444550868L;
    /**
     * 商户号
     */
    @NotBlank
    @Length(max = 32, message = "mchtNo长度不能超过32")
    private String mchtNo;
    /**
     * 微信APPID
     */
    @NotBlank
    @Length(max = 32, message = "appid长度不能超过32")
    private String appid;
    /**
     * APP名称
     */
    @NotBlank
    @Length(max = 32, message = "appName长度不能超过32")
    private String appName;
    /**
     * APP类型 MINI-小程序 PUBLIC-公众号
     */
    @NotBlank
    @Length(max = 32, message = "appType长度不能超过32")
    private String appType;
    /**
     * 渠道商编号
     */
    @NotBlank
    @Length(max = 32, message = "channelNo长度不能超过32")
    private String channelNo;
}