/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.request;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;

/**
 * 获取请求加解密需要用的到sm key
 *
 * @author liluqing
 * @version LzccbGetSm4KeyReq.java, v 0.1 2024-09-18 下午3:59
 */
@Data
@ToString(exclude={"sm2Key", "sm3Key"})
public class LzccbGetSm4KeyReq extends LzccbBaseRequest implements Serializable {

    private static final long serialVersionUID = -3372875306325235775L;

    /**
     * 商编
     */
    @JSONField(serialize = false)
    private String merchantNo;

    /**
     * sm2私钥
     */
    @JSONField(serialize = false)
    private String sm2Key;

    /**
     * sm3密钥
     */
    @JSONField(serialize = false)
    private String sm3Key;

    /**
     * 是否刷新: 0-不刷新
     */
    private String isRefresh = "0";

    public LzccbGetSm4KeyReq() {

    }

    public LzccbGetSm4KeyReq(String merchantNo, String sm2Key, String sm3Key) {
        this.merchantNo = merchantNo;
        this.sm2Key = sm2Key;
        this.sm3Key = sm3Key;
    }
}