package com.fshows.apienum;

import com.fshows.request.merchant.LzccbMerchantAppidBindReq;
import com.fshows.request.merchant.LzccbMerchantAppidQueryReq;
import com.fshows.request.merchant.LzccbMerchantIncomeReq;
import com.fshows.request.merchant.LzccbMerchantMchIdQueryReq;
import com.fshows.request.merchant.LzccbMerchantPayIndexBindReq;
import com.fshows.request.merchant.LzccbMerchantPayIndexQueryReq;
import com.fshows.request.merchant.LzccbMerchantStatusQueryReq;
import com.fshows.response.merchant.LzccbMerchantAppidBindRes;
import com.fshows.response.merchant.LzccbMerchantAppidQueryRes;
import com.fshows.response.merchant.LzccbMerchantIncomeRes;
import com.fshows.response.merchant.LzccbMerchantMchIdQueryRes;
import com.fshows.response.merchant.LzccbMerchantPayIndexBindRes;
import com.fshows.response.merchant.LzccbMerchantPayIndexQueryRes;
import com.fshows.response.merchant.LzccbMerchantStatusQueryRes;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;


/**
 * 泸州银行相关API
 *
 * @author liluqing
 * @version FuiouSettlementApiDefinitionEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum LzccbApiMerchantEnum implements IApiDefinition {

    MERCHANT_INCOME(
            "商户进件接口",
            "/payGateway/channel/MerchantRegitApply",
            "1.0.0",
            "MERCHANT",
            LzccbMerchantIncomeReq.class,
            LzccbMerchantIncomeRes.class
    ),

    MERCHANT_STATUS_QUERY(
            "商户状态查询接口",
            "/payGateway/channel/QueryMerchantStatus",
            "1.0.0",
            "MERCHANT",
            LzccbMerchantStatusQueryReq.class,
            LzccbMerchantStatusQueryRes.class
    ),
    MERCHANT_MCHID_QUERY(
            "渠道子商户号查询接口",
            "/payGateway/channel/QueryChannelMechantNo",
            "1.0.0",
            "MERCHANT",
            LzccbMerchantMchIdQueryReq.class,
            LzccbMerchantMchIdQueryRes.class
    ),
    MERCHANT_APPID_BIND(
            "特约商户绑定appid",
            "/payGateway/channel/DirectMchtAppid",
            "1.0.0",
            "MERCHANT",
            LzccbMerchantAppidBindReq.class,
            LzccbMerchantAppidBindRes.class
    ),
    MERCHANT_PAY_INDEX_BIND(
            "特约商户配置支付目录",
            "/payGateway/channel/DirectMchtPayIndex",
            "1.0.0",
            "MERCHANT",
            LzccbMerchantPayIndexBindReq.class,
            LzccbMerchantPayIndexBindRes.class
    ),
    MERCHANT_APPID_QUERY(
            "查询商户已绑定appid",
            "/payGateway/channel/DirectMchtAppidList",
            "1.0.0",
            "MERCHANT",
            LzccbMerchantAppidQueryReq.class,
            LzccbMerchantAppidQueryRes.class
    ),
    MERCHANT_PAY_INDEX_QUERY(
            "查询商户已配置支付目录",
            "/payGateway/channel/DirectMchtPayIndexList",
            "1.0.0",
            "MERCHANT",
            LzccbMerchantPayIndexQueryReq.class,
            LzccbMerchantPayIndexQueryRes.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;

    /**
     * 接口版本
     */
    private String version;

    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;

    /**
     * 接口类型：
     *  MERCHANT - 商户接口
     *  TRADE  -  交易接口
     *  COMMON  - 通用接口
     */
    private String interfaceType;


    LzccbApiMerchantEnum(String name,
                         String apiSubURI,
                         String version,
                         String interfaceType,
                         Class requestClass,
                         Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.interfaceType = interfaceType;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiURI() {
        return apiSubURI;
    }


    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }

    /**
     * Getter method for property <tt>interfaceType</tt>.
     *
     * @return property value of interfaceType
     */
    public String getInterfaceType() {
        return interfaceType;
    }
}