/*
 * Decompiled with CFR 0.152.
 */
package com.fshows;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fshows.apienum.LzccbApiDefinitionEnum;
import com.fshows.component.LzccbClientConfigModel;
import com.fshows.component.Sm3ApiSignHandler;
import com.fshows.request.LzccbBaseRequest;
import com.fshows.request.LzccbGetSm4KeyReq;
import com.fshows.response.LzccbBaseResponse;
import com.fshows.response.LzccbGetSm4KeyDataRes;
import com.fshows.response.LzccbGetSm4KeyRes;
import com.fshows.sdk.core.client.base.AbstractApiClient;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.sdk.core.client.base.handler.IApiSignHandler;
import com.fshows.sdk.core.client.base.handler.IHttpRequestHandler;
import com.fshows.sdk.core.client.base.handler.ISerializableHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.ClientInfoModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.client.component.http.PostHttpRequestHandler;
import com.fshows.sdk.core.client.component.serializable.JsonSerializableHandler;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.LogUtil;
import com.fshows.sdk.core.util.ReqIdUtil;
import com.fshows.util.SMSaltSigner;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LzccbPayApiClinet
extends AbstractApiClient<LzccbBaseRequest, LzccbBaseResponse, LzccbApiDefinitionEnum> {
    private static final Logger log = LoggerFactory.getLogger(LzccbPayApiClinet.class);
    protected IApiSignHandler iApiSignHandler = new Sm3ApiSignHandler();
    private SMSaltSigner signer = new SMSaltSigner();
    protected ISerializableHandler paramSerializable = new JsonSerializableHandler();
    protected IHttpRequestHandler httpRequestHandler = new PostHttpRequestHandler();

    public LzccbPayApiClinet(DefaultClientConfigModel apiClientConfig) throws FsApiException {
        super(apiClientConfig);
    }

    public LzccbBaseResponse execute(LzccbBaseRequest request, LzccbApiDefinitionEnum apiDefinition) throws FsApiException {
        return (LzccbBaseResponse)this.doExecute(request, apiDefinition);
    }

    public LzccbBaseResponse execute(LzccbBaseRequest request, LzccbApiDefinitionEnum apiDefinition, DefaultClientConfigModel configModel) throws FsApiException {
        return this.doExecute(request, apiDefinition, configModel);
    }

    protected LzccbBaseResponse doExecute(LzccbBaseRequest request, LzccbApiDefinitionEnum iApiDefinition, DefaultClientConfigModel merchantConfigModel) throws FsApiException {
        long beginTime = System.currentTimeMillis();
        LogUtil.info((Logger)log, (String)"{} >> \u6267\u884c\u8bf7\u6c42\u5f00\u59cb >> iApiDefinition={}, request={}", (Object[])new Object[]{this.getClientInfo().getClientDesc(), iApiDefinition, request});
        DefaultRequestContext requestContext = this.buildRequestContext(iApiDefinition, request, merchantConfigModel);
        ApiRequestModel apiRequestModel = null;
        ApiResponseModel apiResponseModel = null;
        try {
            this.checkParam(request, requestContext);
            apiRequestModel = this.buildApiRequestModel(request, requestContext);
            long reqBeginTime = System.currentTimeMillis();
            apiResponseModel = this.httpRequest(apiRequestModel, requestContext);
            long reqEndTime = System.currentTimeMillis();
            Object requestBody = ObjectUtils.defaultIfNull((Object)apiRequestModel.getRequestBody(), (Object)apiRequestModel.getRequestForm());
            LogUtil.info((Logger)log, (String)"{} >> \u8bf7\u6c42\u7ed3\u675f[\u5bc6\u6587] >> url={}, method={}, request={}, response={}, cost={}ms, reqcost={}ms", (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), iApiDefinition, requestBody, apiResponseModel.getResponseBody(), System.currentTimeMillis() - beginTime, reqEndTime - reqBeginTime});
            LzccbBaseResponse response = this.buildApiResponse(apiResponseModel, apiRequestModel, requestContext);
            LogUtil.info((Logger)log, (String)"{} >> \u8bf7\u6c42\u7ed3\u675f[\u660e\u6587] >> url={}, method={}, request={}, response={}, cost={}ms", (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), requestContext.getIApiDefinition(), JSONObject.toJSONString((Object)apiRequestModel.getRequest()), apiResponseModel.getResponseBody(), System.currentTimeMillis() - beginTime});
            return response;
        }
        catch (FsApiException e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u5f02\u5e38 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), iApiDefinition, request, apiRequestModel, apiResponseModel});
            throw e;
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u5f02\u5e38 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), iApiDefinition, request, apiRequestModel, apiResponseModel});
            throw new FsApiException(e.getMessage(), (Throwable)e);
        }
    }

    protected DefaultRequestContext buildRequestContext(LzccbApiDefinitionEnum tradeApiDefinitionEnum, LzccbBaseRequest request, DefaultClientConfigModel merchantConfig) {
        DefaultRequestContext context = new DefaultRequestContext();
        context.setRequestId(ReqIdUtil.getId());
        context.setIApiDefinition((IApiDefinition)tradeApiDefinitionEnum);
        LzccbClientConfigModel clientConfig = (LzccbClientConfigModel)this.apiClientConfig;
        LzccbClientConfigModel config = this.newLzccbClientConfigModel(clientConfig);
        if (merchantConfig != null) {
            config.setAgentId(StringUtils.isEmpty((CharSequence)merchantConfig.getAgentId()) ? clientConfig.getAgentId() : merchantConfig.getAgentId());
            config.setAppId(StringUtils.isEmpty((CharSequence)merchantConfig.getAppId()) ? clientConfig.getAppId() : merchantConfig.getAppId());
            config.setFubeiPrivateKey(StringUtils.isEmpty((CharSequence)merchantConfig.getFubeiPrivateKey()) ? clientConfig.getFubeiPrivateKey() : merchantConfig.getFubeiPrivateKey());
            config.setPayCompanyPublicKey(StringUtils.isEmpty((CharSequence)merchantConfig.getPayCompanyPublicKey()) ? clientConfig.getPayCompanyPublicKey() : merchantConfig.getPayCompanyPublicKey());
            config.setMd5SignKey(merchantConfig.getMd5SignKey());
            config.setSm4Key(((LzccbClientConfigModel)merchantConfig).getSm4Key());
        }
        if (!LzccbApiDefinitionEnum.GET_SM4_KEY.equals((Object)tradeApiDefinitionEnum) && !LzccbApiDefinitionEnum.CHANNEL_GET_SM4_KEY.equals((Object)tradeApiDefinitionEnum) && StringUtils.isBlank((CharSequence)config.getSm4Key())) {
            throw new FsApiException("\u8c03\u7528\u6cf8\u5dde\u94f6\u884c\u63a5\u53e3sm4Key\u5fc5\u586b");
        }
        context.setApiClientConfig((DefaultClientConfigModel)config);
        context.setClientInfoModel(this.getClientInfo());
        return context;
    }

    private LzccbClientConfigModel newLzccbClientConfigModel(LzccbClientConfigModel clientConfigModel) {
        LzccbClientConfigModel configModel = new LzccbClientConfigModel();
        configModel.setAppId(clientConfigModel.getAppId());
        configModel.setAgentId(clientConfigModel.getAgentId());
        configModel.setFubeiPrivateKey(clientConfigModel.getFubeiPrivateKey());
        configModel.setPayCompanyPublicKey(clientConfigModel.getPayCompanyPublicKey());
        configModel.setPassword(clientConfigModel.getPassword());
        configModel.setApiParentURL(clientConfigModel.getApiParentURL());
        configModel.setMd5SignKey(clientConfigModel.getMd5SignKey());
        configModel.setSignTypeEnum(clientConfigModel.getSignTypeEnum());
        configModel.setVrifySignResponse(clientConfigModel.isVrifySignResponse());
        configModel.setCheckParam(clientConfigModel.isCheckParam());
        configModel.setConnectionTimeout(clientConfigModel.getConnectionTimeout());
        configModel.setReadTimeout(clientConfigModel.getReadTimeout());
        configModel.setCharset(clientConfigModel.getCharset());
        configModel.setHump(clientConfigModel.isHump());
        configModel.setExtendParam(new HashMap(clientConfigModel.getExtendParam()));
        configModel.setSingIgnoreNull(clientConfigModel.isSingIgnoreNull());
        return configModel;
    }

    public String getSM4Key(LzccbGetSm4KeyReq lzccbGetSm4KeyReq) {
        LzccbClientConfigModel configModel = new LzccbClientConfigModel();
        configModel.setAppId(lzccbGetSm4KeyReq.getMerchantNo());
        configModel.setFubeiPrivateKey(lzccbGetSm4KeyReq.getSm2Key());
        configModel.setMd5SignKey(lzccbGetSm4KeyReq.getSm3Key());
        LzccbGetSm4KeyRes lzccbGetSm4KeyRes = (LzccbGetSm4KeyRes)this.doExecute(lzccbGetSm4KeyReq, LzccbApiDefinitionEnum.GET_SM4_KEY, (DefaultClientConfigModel)configModel);
        System.out.println(lzccbGetSm4KeyRes.getData().getSm4Key());
        if (!"00000200".equals(lzccbGetSm4KeyRes.getCode())) {
            LogUtil.debug((Logger)log, (String)"{} >> \u8bf7\u6c42\u5f02\u5e38 >> sm4key\u83b7\u53d6\u5931\u8d25 >> apiDefinition={}, response={}", (Object[])new Object[]{this.getClientInfo().getClientDesc(), LzccbApiDefinitionEnum.GET_SM4_KEY, lzccbGetSm4KeyRes});
            throw new FsApiException(lzccbGetSm4KeyRes.getMsg());
        }
        return lzccbGetSm4KeyRes.getData().getSm4Key();
    }

    public String getChannelSM4Key(LzccbGetSm4KeyReq lzccbGetSm4KeyReq) {
        LzccbClientConfigModel configModel = new LzccbClientConfigModel();
        configModel.setAppId(lzccbGetSm4KeyReq.getMerchantNo());
        configModel.setFubeiPrivateKey(lzccbGetSm4KeyReq.getSm2Key());
        configModel.setMd5SignKey(lzccbGetSm4KeyReq.getSm3Key());
        LzccbGetSm4KeyRes lzccbGetSm4KeyRes = (LzccbGetSm4KeyRes)this.doExecute(lzccbGetSm4KeyReq, LzccbApiDefinitionEnum.CHANNEL_GET_SM4_KEY, (DefaultClientConfigModel)configModel);
        System.out.println(lzccbGetSm4KeyRes.getData().getSm4Key());
        if (!"00000200".equals(lzccbGetSm4KeyRes.getCode())) {
            LogUtil.debug((Logger)log, (String)"{} >> \u8bf7\u6c42\u5f02\u5e38 >> \u6e20\u9053\u5546sm4key\u83b7\u53d6\u5931\u8d25 >> apiDefinition={}, response={}", (Object[])new Object[]{this.getClientInfo().getClientDesc(), LzccbApiDefinitionEnum.CHANNEL_GET_SM4_KEY, lzccbGetSm4KeyRes});
            throw new FsApiException(lzccbGetSm4KeyRes.getMsg());
        }
        return lzccbGetSm4KeyRes.getData().getSm4Key();
    }

    protected ApiRequestModel buildApiRequestModel(LzccbBaseRequest request, DefaultRequestContext context) {
        LzccbClientConfigModel defaultClientConfigModel = (LzccbClientConfigModel)context.getApiClientConfig();
        ApiRequestModel apiRequestModel = new ApiRequestModel();
        apiRequestModel.setApiURL(context.getApiClientConfig().getApiParentURL() + context.getIApiDefinition().getApiURI());
        HashMap<String, String> headerMap = new HashMap<String, String>();
        apiRequestModel.setHeadMap(headerMap);
        headerMap.put("Mer-Id", defaultClientConfigModel.getAppId());
        headerMap.put("Key-Sn", "1");
        headerMap.put("Alg-Sn", "1");
        headerMap.put("Time-Stamp", DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        headerMap.put("Content-Type", "application/json;charset=utf-8");
        headerMap.put("Accept", "application/json");
        headerMap.put("Accept-Encoding", "identity");
        apiRequestModel.setRequest((IRequestDefinition)request);
        String requestBody = this.paramSerializable.serializeObject(apiRequestModel, context);
        apiRequestModel.setRequestBody(requestBody);
        if (!LzccbApiDefinitionEnum.GET_SM4_KEY.equals(context.getIApiDefinition()) && !LzccbApiDefinitionEnum.CHANNEL_GET_SM4_KEY.equals(context.getIApiDefinition())) {
            String encRequestBody = this.signer.encryptData(defaultClientConfigModel.getSm4Key(), requestBody);
            apiRequestModel.setRequestBody(encRequestBody);
        }
        apiRequestModel.setRequestSign(this.iApiSignHandler.sign(apiRequestModel, context));
        headerMap.put("Sign", apiRequestModel.getRequestSign());
        return apiRequestModel;
    }

    protected ClientInfoModel getClientInfo() {
        ClientInfoModel clientInfoModel = new ClientInfoModel();
        clientInfoModel.setClientName("\u6cf8\u5dde\u94f6\u884c");
        clientInfoModel.setClientCode("lzccb-sdk");
        return clientInfoModel;
    }

    protected LzccbBaseResponse buildApiResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        LzccbGetSm4KeyRes lzccbGetSm4KeyRes;
        LzccbGetSm4KeyDataRes dataRes;
        LzccbClientConfigModel clientConfigModel = (LzccbClientConfigModel)requestContext.getApiClientConfig();
        String ciphertext = apiResponseModel.getResponseBody();
        if (!(LzccbApiDefinitionEnum.GET_SM4_KEY.equals(requestContext.getIApiDefinition()) || StringUtils.startsWith((CharSequence)ciphertext, (CharSequence)"{") || StringUtils.startsWith((CharSequence)ciphertext, (CharSequence)"["))) {
            ciphertext = this.signer.decryptData(clientConfigModel.getSm4Key(), ciphertext);
        }
        IApiDefinition apiDefinition = requestContext.getIApiDefinition();
        JSONObject responseJsonObj = JSONObject.parseObject((String)ciphertext);
        if (responseJsonObj.containsKey((Object)"data")) {
            Object chilrenDataObj;
            JSONObject dataJson;
            Object dataObj = responseJsonObj.get((Object)"data");
            if (dataObj instanceof JSONObject) {
                dataJson = (JSONObject)dataObj;
                responseJsonObj.putAll((Map)dataJson);
            }
            if (dataObj instanceof JSONArray && apiDefinition.equals((Object)LzccbApiDefinitionEnum.ORDER_QUERY) && !(dataJson = (JSONArray)dataObj).isEmpty() && (chilrenDataObj = dataJson.get(0)) instanceof JSONObject) {
                responseJsonObj.putAll((Map)((JSONObject)chilrenDataObj));
            }
        }
        apiResponseModel.setResponseBody(ciphertext);
        apiResponseModel.setResponse((IResponseDefinition)responseJsonObj.toJavaObject(requestContext.getIApiDefinition().getResponseClass()));
        Boolean verifySign = this.iApiSignHandler.verifySign(apiResponseModel, apiRequestModel, requestContext);
        if (clientConfigModel.isVrifySignResponse() && !Boolean.TRUE.equals(verifySign)) {
            throw new FsApiException("\u9a8c\u7b7e\u5931\u8d25");
        }
        if (apiResponseModel.getResponse() instanceof LzccbGetSm4KeyRes && (dataRes = (lzccbGetSm4KeyRes = (LzccbGetSm4KeyRes)apiResponseModel.getResponse()).getData()) != null) {
            dataRes.setSm4Key(this.signer.decryptSm2(clientConfigModel.getFubeiPrivateKey(), dataRes.getSm4Key()));
        }
        return (LzccbBaseResponse)apiResponseModel.getResponse();
    }

    protected ApiResponseModel httpRequest(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws IOException {
        return this.httpRequestHandler.httpRequest(apiRequestModel, requestContext);
    }
}

