/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request.merchant;

import com.fshows.request.LzccbBaseRequest;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;

/**
 * 机具报备接口 request
 *
 * @author
 * @version LzccbDeviceRegisterReq.java, v 0.1 2024-09-12 09:52:48
 */
@Data
public class LzccbMerchantMchIdQueryReq extends LzccbBaseRequest implements Serializable {

    private static final long serialVersionUID = 1755720156061128721L;
    /**
     * 渠道商编号
     */
    @NotBlank
    @Length(max = 32, message = "channelNo长度不能超过32")
    private String channelNo;

    /**
     * 商户号
     */
    @NotBlank
    @Length(max = 32, message = "merchantNo长度不能超过32")
    private String merchantNo;

    /**
     * 渠道类型
     * 不送表示查询三个通道
     * WEXIN --微信
     * ALI- 支付宝
     * UNION -银联
     */
    @Length(max = 32, message = "pmcType长度不能超过32")
    private String pmcType;
}