package com.fshows.component;

/**
 * Body签名块对象<br/>
 * <li>对于使用HTTP的Body来传递参数的情况(POST方法)，待加密数据=uri&Body&商户号(Mer-Id)&时间戳(Time-Stamp)</li>
 */
public class BodySignBlock implements ISignBlock {
	/** 接口uri */
	private String uri;
	/** 商户编号[对应http header:Mer-Id] */
	private String merId;
	/** 时间戳[对应http header:Time-Stamp] */
	private String timeStamp;
	/** http body数据 */
	private String bodyString;
	
	/**
	 * 构造函数
	 * @param uri 接口uri
	 * @param merId 商户编号[对应http header:Mer-Id]
	 * @param timeStamp 时间戳[对应http header:Time-Stamp]
	 * @param bodyString http body数据
	 */
	public BodySignBlock(String uri, String merId, String timeStamp,
			String bodyString) {
		super();
		this.uri = uri;
		this.merId = merId;
		this.timeStamp = timeStamp;
		this.bodyString = bodyString;
	}

	public String getSignBlock() {
		StringBuffer sb = new StringBuffer();
		sb.append(uri).append("&");
		sb.append(bodyString).append("&");
		sb.append(merId).append("&");
		sb.append(timeStamp);
		return sb.toString();
	}
	
	public String getUri() {
		return uri;
	}

	public void setUri(String uri) {
		this.uri = uri;
	}

	public String getMerId() {
		return merId;
	}

	public void setMerId(String merId) {
		this.merId = merId;
	}

	public String getTimeStamp() {
		return timeStamp;
	}

	public void setTimeStamp(String timeStamp) {
		this.timeStamp = timeStamp;
	}

	public String getBodyString() {
		return bodyString;
	}

	public void setBodyString(String bodyString) {
		this.bodyString = bodyString;
	}

	@Override
	public String toString() {
		return "BodySignBlock [uri=" + uri + ", merId=" + merId
				+ ", timeStamp=" + timeStamp + ", bodyString=" + bodyString
				+ "]";
	}
}
