package com.fshows.apienum;

import com.fshows.request.merchant.LzccbMerchantIncomeReq;
import com.fshows.request.merchant.LzccbMerchantMchIdQueryReq;
import com.fshows.request.merchant.LzccbMerchantStatusQueryReq;
import com.fshows.response.merchant.LzccbMerchantIncomeRes;
import com.fshows.response.merchant.LzccbMerchantMchIdQueryRes;
import com.fshows.response.merchant.LzccbMerchantStatusQueryRes;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;


/**
 * 泸州银行相关API
 *
 * @author liluqing
 * @version FuiouSettlementApiDefinitionEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum LzccbApiMerchantEnum implements IApiDefinition {

    MERCHANT_INCOME(
            "商户进件接口",
            "/payGateway/channel/MerchantRegitApply",
            "1.0.0",
            "MERCHANT",
            LzccbMerchantIncomeReq.class,
            LzccbMerchantIncomeRes.class
    ),

    MERCHANT_STATUS_QUERY(
            "商户状态查询接口",
            "/payGateway/channel/QueryMerchantStatus",
            "1.0.0",
            "MERCHANT",
            LzccbMerchantStatusQueryReq.class,
            LzccbMerchantStatusQueryRes.class
    ),
    MERCHANT_MCHID_QUERY(
            "渠道子商户号查询接口",
            "/payGateway/channel/QueryChannelMechantNo",
            "1.0.0",
            "MERCHANT",
            LzccbMerchantMchIdQueryReq.class,
            LzccbMerchantMchIdQueryRes.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;

    /**
     * 接口版本
     */
    private String version;

    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;

    /**
     * 接口类型：
     *  MERCHANT - 商户接口
     *  TRADE  -  交易接口
     *  COMMON  - 通用接口
     */
    private String interfaceType;


    LzccbApiMerchantEnum(String name,
                         String apiSubURI,
                         String version,
                         String interfaceType,
                         Class requestClass,
                         Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.interfaceType = interfaceType;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiURI() {
        return apiSubURI;
    }


    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }

    /**
     * Getter method for property <tt>interfaceType</tt>.
     *
     * @return property value of interfaceType
     */
    public String getInterfaceType() {
        return interfaceType;
    }
}