/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Random;

public final class StringUtil {
    public static final char[] DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static boolean stringIsNull(String str) {
        return str == null || str.isEmpty();
    }

    public static byte[] hex2byte(String s) {
        byte[] src = s.toLowerCase().getBytes();
        byte[] ret = new byte[src.length / 2];
        for (int i = 0; i < src.length; i += 2) {
            byte hi = src[i];
            byte low = src[i + 1];
            hi = (byte)(hi >= 97 && hi <= 102 ? 10 + (hi - 97) : hi - 48);
            low = (byte)(low >= 97 && low <= 102 ? 10 + (low - 97) : low - 48);
            ret[i / 2] = (byte)(hi << 4 | low);
        }
        return ret;
    }

    public static String byte2hex(byte[] b) {
        char[] out = new char[b.length * 2];
        for (int i = 0; i < b.length; ++i) {
            byte c = b[i];
            out[i * 2] = DIGIT[c >>> 4 & 0xF];
            out[i * 2 + 1] = DIGIT[c & 0xF];
        }
        return new String(out);
    }

    public static String string2Unicode(String s) {
        if (StringUtil.stringIsNull(s)) {
            return s;
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) >= '\u2018') {
                result.append('\\');
                result.append('u');
                String hex = Integer.toHexString(s.charAt(i));
                result.append(hex);
                continue;
            }
            result.append(s.charAt(i));
        }
        return result.toString();
    }

    public static String unicode2String(String s) {
        if (StringUtil.stringIsNull(s)) {
            return s;
        }
        StringBuffer result = new StringBuffer();
        int start = 0;
        int end = 0;
        while ((end = s.indexOf("\\u", start)) != -1) {
            result.append(s.substring(start, end));
            start = end + 2;
            end = start + 4;
            if (end > s.length()) break;
            char c = (char)Integer.parseInt(s.substring(start, end), 16);
            result.append(c);
            start = end;
        }
        if (start < s.length()) {
            result.append(s.substring(start));
        }
        return result.toString();
    }

    public static String map2String(Map<String, ?> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String val = params.get(key).toString();
            sb.append(key);
            sb.append("=");
            sb.append(val);
            if (i >= keys.size() - 1) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    public static byte[] genRandomByte(int size) {
        byte[] ret = new byte[size];
        new Random().nextBytes(ret);
        return ret;
    }

    public static String getCurrentTimeStr() {
        Date date = new Date();
        SimpleDateFormat form = new SimpleDateFormat("yyyyMMddHHmmss");
        return form.format(date);
    }
}

